/* avid_nul.h
 *    Include module for "aterm.h" for dummy display functions.
 *    Programmed 1994, Feb 1995 by Mark D. Rejhon.
 *    EMail: marky@ottawa.com, ag115@freenet.carleton.ca
 *
 *    This module includes instructions on how to use the display functions
 *    (defined in all avid*.h modules) used by the aprint/afprint functions.
 *    If you make a new avid*.h module for yourself, make a copy of this
 *    module, under a different name than "avid_nul.h".
 *
 * LICENSE:
 *    This version can be freely modified and redistributed using the GNU
 *    public license.  Please refer to included "COPYING" file for details.
 *    Please submit ALL changes to this code via Internet Email to address
 *    ag115@freenet.carleton.ca  (permanent address, will forward Email to
 *    my current Internet Service Provider)
 *
 * --------------------------------------------------------------------------
 * NOTES ABOUT FUNCTIONS
 *    - The following are detailed information on each display function
 *      required for the aprint/afprint terminal display functions.
 *    - All these return void, all values are int unless otherwise specified.
 *    - All co-ordinate values should have an origin of (1,1).
 *    - Error checking on bad co-ordinate values are not critical if used
 *       mainly with the aprint/afprint terminal display functions.
 *    - See adefs.h for information on the 'video variables structure'.
 *
 * SUMMARY
 *    beep()
 *    poscur(aterm_type *vid, row, col)
 *    clearbox(aterm_type *vid, top, left, bot, right)
 *    fillbox(aterm_type *vid, top, left, bot, right, chr)
 *    scrollup(aterm_type *vid, top, left, bot, right, lines)
 *    scrolldn(aterm_type *vid, top, left, bot, right, lines)
 *    scrollleft(aterm_type *vid, linenum, left, right, chars)
 *    scrollright(aterm_type *vid, linenum, left, right, chars)
 *    pokechar(aterm_type *vid, char outch)
 *    outstring(aterm_type *vid, char *outstr, len)
 */

/* Make sure we define everything only once. Leave this part alone! */
#ifndef AVID_H
#define AVID_H

/* Include adefs.h in case it was not included yet */
#include "adefs.h"

/* --------------------------------------------------------------------------
 * beep()
 *
 *   PURPOSE
 *     Cause a beep.
 *   NOTES
 *     This is called everytime an ascii code 7 is printed using aprint/
 *     afprint functions.  Not critical to operation of aprint/afprint
 *     and should not be necessary for any other routines in this module.
 *   RESULT
 *     A brief sound or flash may be produced.
 */
void beep()
{ }

/* --------------------------------------------------------------------------
 * poscur(aterm_type *vid, row, col)
 *
 *   PURPOSE
 *     Position physical cursor in the terminal video buffer.
 *   PARAMETERS
 *     vid = video variables structure.
 *     row = row for physical cursor.
 *     col = column for physical cursor.
 *   NOTES
 *     Cosmetic, and is not critical to aprint/afprint functions, so this
 *     function can be empty if you don't want aprint/afprint to position
 *     any sort of visible cursor automatically.
 *   RESULT
 *     Any physical cursor, may be moved to position (col,row) in
 *     video buffer.
 */
void poscur(aterm_type *vid, int row, int col)
{ }

/* --------------------------------------------------------------------------
 * clearbox(aterm_type *vid, top, left, bot, right)
 *
 *   PURPOSE
 *     Clears a block of text on the video buffer.
 *   REQUIRES
 *     vid   = video variables structure
 *     top   = absolute row, top border of text block
 *     left  = absolute column, left border of text block
 *     bot   = absolute row, bottom border of text block
 *     right = absolute column, right border of text block
 *   NOTES
 *     Parameters top,left,bot,right should be relative to the entire
 *     video buffer, not to the terminal 'window' within it.
 *     This can be a C macro for fillbox(vid, top, left, bot, right, 32)
 *   RESULT
 *     Text block enclosed by top,left,bot,right is cleared to spaces
 *     using the attributes given by vid->attr.
 */
void clearbox(aterm_type *vid, int top, int left, int bot, int right)
{ }

/* --------------------------------------------------------------------------
 * fillbox(aterm_type *vid, top, left, bot, right, chr)
 *
 *   PURPOSE
 *     Fills a block of text on the video buffer to a specific char.
 *   REQUIRES
 *     vid   = video variables structure
 *     top   = absolute row, top border of text block
 *     left  = absolute column, left border of text block
 *     bot   = absolute row, bottom border of text block
 *     right = absolute column, right border of text block
 *     chr   = character to use for fill of block.
 *   NOTES
 *     Parameters top,left,bot,right should be relative to the entire
 *     video buffer, not to the terminal 'window' within it.
 *   RESULT
 *     Text block enclosed by top,left,bot,right is filled with character
 *     chr and the attributes given by vid->attr.
 */
void fillbox(aterm_type *vid, int top, int left, int bot, int right, int chr)
{ }

/* --------------------------------------------------------------------------
 * scrollup(aterm_type *vid, top, left, bot, right, lines)
 *
 *   PURPOSE
 *     Scrolls a block of text on the video buffer upwards.
 *   REQUIRES
 *     vid   = video variables structure
 *     top   = absolute row, top border of text block
 *     left  = absolute column, left border of text block
 *     bot   = absolute row, bottom border of text block
 *     right = absolute column, right border of text block
 *     lines = number of lines to scroll block
 *   NOTES
 *     Any new blank areas that appears, is cleared to spaces using
 *     attributes in vid->attr.  If 'lines' equals 0 or exceeds height
 *     of text block, then the text block is completely cleared, perhaps
 *     using the clearbox() function.
 *   RESULT
 *     Text block enclosed by top,left,bot,right is scrolled upwards
 *     by number of lines given by parameter 'lines'.
 */
void scrollup(aterm_type *vid, int top, int left, int bot, int right, int lines)
{ }

/* --------------------------------------------------------------------------
 * scrolldn(aterm_type *vid, top, left, bot, right, lines)
 *
 *   PURPOSE
 *     Scrolls a block of text on the video buffer downwards.
 *   NOTES
 *     Parameters and functionality are exactly the same as scrollup()
 *     other than the direction of the scrolling.
 */
void scrolldn(aterm_type *vid, int top, int left, int bot, int right, int lines)
{ }

/* --------------------------------------------------------------------------
 * scrollleft(aterm_type *vid, linenum, left, right, chars)
 *
 *   PURPOSE
 *     Scrolls part of a line of text on the video buffer towards the left.
 *   REQUIRES
 *     vid = pointer to data area of video variables of video buffer
 *     linenum = row of line on video buffer to scroll
 *     left = leftmost character of line
 *     right = rightmost character of line
 *     chars = number of character steps to scroll
 *   NOTES
 *     This function can be used to 'delete characters' at cursor position.
 *     When used this way, the parameter 'linenum' is cursor row, 'left'
 *     is cursor column, 'right' is absolute position of the right border
 *     of terminal window.
 *   RESULT
 *     The one-line block of text on line number 'linenum' bounded by
 *     columns 'left' and 'right' is scrolled to the left, by number of
 *     units indicated by 'chars'.  The new blank area that appears, is
 *     cleared to spaces with attributes in vid->attr.
 */
void scrollleft(aterm_type *vid, int linenum, int left, int right, int chars)
{ }

/* --------------------------------------------------------------------------
 * scrollright(aterm_type *vid, linenum, left, right, chars)
 *
 *   PURPOSE
 *     Scrolls part of a line of text on the video buffer towards the right.
 *   NOTES
 *     Parameters and functionality are exactly the same as scrollleft()
 *     other than the direction of the scrolling.  This function can be
 *     used to 'delete characters' at cursor position.
 */
void scrollright(aterm_type *vid, int linenum, int left, int right, int chars)
{ }

/* --------------------------------------------------------------------------
 * pokechar(aterm_type *vid, char outch)
 *
 *   PURPOSE
 *     Writes a char to video buffer without affecting cursor position.
 *   REQUIRES
 *     outch = the character to be poked.
 *   NOTES
 *     Cursor position is not affected.
 *   RESULT
 *     Character is output to the video buffer at current cursor position.
 */
void pokechar(aterm_type *vid, char outch)
{ }

/* --------------------------------------------------------------------------
 * outstring(aterm_type *vid, char *outstr, len)
 *
 *   PURPOSE
 *     Output a string to the terminal window within the video buffer.
 *   REQUIRES
 *     outstr = the string to be output.
 *   NOTES
 *         There is no processing done for control codes, all control codes
 *     are printed.  This function should be able to accept all 255 chars
 *     (except null).  If the system's display cannot display certain
 *     control codes directly onto the screen, then translation should
 *     be performed to substitute a printable character for all unprintable
 *     characters.
 *         There is line wrapping.  When a char is printed on last column
 *     of a line in the terminal window, the cursor wraps to the first
 *     column of the next line.  If it was the last row of the terminal
 *     window, then the window is scrolled upwards (using the scrollup()
 *     function if needed).
 *         There is insert mode capability.  If insert mode is enabled
 *     (whenever vid->insmode is non-zero), characters to the right of the
 *     cursor should be scrolled towards the right.  The scrollright()
 *     function can be used.  Nothing is done if cursor wraps to next line.
 *         For advanced coders only: If you are a good C coder and you
 *     want to maximize speed of this function, you only need one call
 *     to the scrollright() function at the most, no matter what the
 *     length of the string is, and even if the string wraps to the next
 *     line!  (Hint: Ignore all inserting until the last cursor-wrap has
 *     been done for the given string, then do a single scrollright() call
 *     at once, before printing the last line.)
 *   RESULT
 *     String is output to the terminal window at current cursor position.
 */
void outstring(aterm_type *vid, char *outstr, int len)
{ }

/* The following #endif line must be the last line */
#endif
