/* aconst.h
 *    Include module for aterm.h for definitions and constants.
 *    Programmed 1994, Feb 1995 by Mark D. Rejhon.
 *    EMail: marky@ottawa.com, ag115@freenet.carleton.ca
 *
 * LICENSE:
 *    This version can be freely modified and redistributed using the GNU
 *    public license.  Please refer to included "COPYING" file for details.
 *    Please submit ALL changes to this code via Internet Email to address
 *    ag115@freenet.carleton.ca  (permanent address, will forward Email to
 *    my current Internet Service Provider)
 */

/* Make sure that we only define everything once */
#ifndef ADEFS_H
#define ADEFS_H

#define TRUE 1                    /* Boolean value */
#define FALSE 0                   /* Boolean value */
#define nul 0                     /* Null char */
#define avt 22                    /* AVT prefix char */
#define rle 25                    /* RLE prefix char */
#define esc 27                    /* ESC prefix char */
#define bracket 91                /* Bracket char */

#define MaxCodeLen 260            /* Max length of any code */
#define MaxRecurseLevels 8        /* Max recursions allowed for afprint */
#define ScreenSeg 0xB800          /* Memory segment for screen */

typedef unsigned char byte;
typedef unsigned int word;

/* The following is a lookup table for the lengths of AVATAR codes.
 * It is indexed using the value right after Control-V code prefix
 * With the exception of the ^V^Y string which is variable length.
 */
static const byte AVTtable[256] = {
  0,2,1,1,1,1,1,1,3,1,6,6,4,5,1,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

/* The following is a lookup table of types of ANSI code sequence characters.
 * Currently 1 represents valid internal sequence characters.
 */
#define SEQ 1
#define SUFFIX 0
static const byte ANSIchar[256] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*00-1F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, /*20-3F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*40-5F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*60-7F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*80-9F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*A0-BF*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*C0-DF*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  /*E0-FF*/
};

/* The following is a lookup table for which characters are normally
 * not printable. 0 means printable, 1 means non-printable.
 */
static const byte ControlCode[256] = {
  1,0,0,0,0,0,0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,0,0, /*00-1F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*20-3F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*40-5F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*60-7F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*80-9F*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*A0-BF*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /*C0-DF*/
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0  /*E0-FF*/
};

/* The following is a translation table for ANSI color to IBM color */
static const byte ANSI2IBM[8] = { 0,4,2,6,1,5,3,7 };

/* This is a structure declaring attributes of the terminal window.
 * Cursor positions (absolute) are relative to the screen, while
 * cursor positions (relative) are relative to the terminal window.
 */
typedef struct aterm_display {    /* Data area of video variables */
  byte *buffer;          /* Pointer to an internal screen buffer */
  byte scrwidth;         /* Width of screen that the display window is in */
  byte wtop;             /* Top row of display window (absolute) */
  byte wleft;            /* Left col of display window (absolute) */
  byte wbot;             /* Bottom row of display window (absolute) */
  byte wright;           /* Right col of display window (absolute) */
  byte wtopzone;         /* Top of scroll zone for Esc[r (absolute) */
  byte wbotzone;         /* Bottom of scroll zone for Esc[r (absolute) */
  byte topzone;          /* Top of scroll zone for Esc[r (relative) */
  byte botzone;          /* Bottom of scroll zone for Esc[r (relative) */
  byte height;           /* Height of display window, same as (wbot - wtop + 1) */
  byte width;            /* Width of display window, same as (wright - wleft + 1) */
  byte row;              /* Cursor row (relative) */
  byte col;              /* Cursor column (relative) */
  byte attr;             /* Attributes */
  byte insmode;          /* Insert mode */
  byte saverow;          /* Save cursor row for Esc[s (relative) */
  byte savecol;          /* Save cursor col for Esc[s (relative) */
  byte ansi;             /* TRUE if ANSI/VT102 processing should be done */
  byte avatar;           /* TRUE if AVATAR processing should be done */
  byte destbs;           /* TRUE if destructive backspaces enabled */
  byte beep;             /* TRUE if beeps enabled */
  byte codetype;         /* Type of code being buffered - ANSI or AVT */
  byte codelen;          /* Length of code when AVT codes are being buffered */
  word codeptr;          /* Pointer to current character in buffer string. */
  byte code[MaxCodeLen]; /* Buffer string for display code (ANSI or AVT) */
} aterm_type;

#endif
