.8086
.MODEL tiny, pascal, os_dos

.STACK
.DATA
Intro	BYTE 'DaZZle (SLoW VeRsIoN) for use with EGA/VGA.',13,10,'Feb 1992 by Viddy-oH Soft, Programmed by Mark D. Rejhon.',13,10,'$'
Success BYTE '>DaZZle is now installed.',13,10,'$'
Removed BYTE '>DaZZle has been de-installed.',13,10,'$'
Fail	BYTE '>DaZZle already previously installed!',13,10,'$'
.CODE
.STARTUP
	jmp Install		;Jumps to interrupt installation procedure.

Vector	DWORD ? 		;Resident data for TSR.
Timer	BYTE 6Dh		;(must be in code segment)
Limit	BYTE 3
Leng	BYTE 2
Busy	BYTE 0
;	Data	   Color	    From color		Order of transistion
;	------	   ----------	    ----------		--------------------
Gee	BYTE 8	   ;Dark grey	    ;0	  ;Black	    ;Dark grey
	BYTE 5	   ;Magenta	    ;1	  ;Blue 	    ;Light grey
	BYTE 3	   ;Cyan	    ;2	  ;Green	    ;White
	BYTE 11    ;Bright cyan     ;3	  ;Cyan 	    ;Yellow
	BYTE 6	   ;Brown	    ;4	  ;Red		    ;Bright green
	BYTE 13    ;Bright magenta  ;5	  ;Magenta	    ;Green
	BYTE 0	   ;Black	    ;6	  ;Brown	    ;Cyan
	BYTE 15    ;White	    ;7	  ;Light grey	    ;Bright cyan
	BYTE 7	   ;Light grey	    ;8	  ;Dark grey	    ;Bright blue
	BYTE 1	   ;Blue	    ;9	  ;Bright blue	    ;Blue
	BYTE 2	   ;Green	    ;10   ;Bright green     ;Magenta
	BYTE 9	   ;Bright blue     ;11   ;Bright cyan	    ;Bright magenta
	BYTE 4	   ;Red 	    ;12   ;Bright red	    ;Bright red
	BYTE 12    ;Bright red	    ;13   ;Bright magenta   ;Red
	BYTE 10    ;Bright green    ;14   ;Bright cyan	    ;Brown
	BYTE 14    ;Yellow	    ;15   ;White	    ;Black



Dazzle:			;Start of interrupt handler
	.IF cs:Busy != 0	;Did Dazzle interrupt itself?
	jmp cs:Vector		;If so, exit through original vector.
	.ENDIF
	inc cs:Busy		;Increment busy flag.
	sti			;Enable interrupts
	push ax 		;Save registers
	push bx
	push cx
	push dx
	push ds
	push cs
	pop ds
	mov al, Timer		;Increments timer (for segment of screen to
	inc al			;update. Does 1/4th of the screen every time
	cmp al, Limit		;this program is run through the interrupt.
	.IF al > Limit		;And resets timer to 0 if it equals
	mov al, 0		;'Limit' (currently 3)
	.ENDIF
	mov bx, OFFSET Timer
	mov [bx],al
Update: mov dx,0B800h		;Pointer to text video memory segment
	mov ds,dx		;Calculates offset of the desired segment
	mov bx,0460h		;of the screen to update
	mul bx
	mov bx,ax
	inc bx
	mov cx,0h
	mov ax,0h
	mov cx,0230h		  ;Initialization ends here
DoIt:	mov al,[bx]		  ;Loop for setting colors in video memory.
	mov bp,ax
	and al,0F0h
	and bp,0Fh
	or al,cs:BYTE PTR Gee[bp]
	mov [bx],al
	add bx,2
	loop DoIt
	cli
	dec cs:Busy		  ;Clears Dazzle execution flag.
	pop ds			  ;Restore registers
	pop dx
	pop cx
	pop bx
	pop ax
	jmp cs:Vector		  ;Exits through original interrupt.

EndDazzle:			  ;Interrupt handler stops here

Install:
	mov dx, OFFSET Intro	    ;Prints introduction message on screen.
	mov ah,09h
	int 21h
	mov ax,0351Ch
	int 21h
	mov WORD PTR Vector[0], bx   ;Save original vector
	mov WORD PTR Vector[2], es
	push cs
	pop cx

	mov dx,0040h		     ;Check if Dazzle is already installed
	mov si, OFFSET Dazzle	     ;Loop to search through first megabyte.
Check:	cmp dx, cx		     ;Checks if program is comparing itself.
	jne KeepGo
	add dx, 08h		     ;If so, skip this section of memory.
KeepGo:	mov es,dx
	mov bx,0h
Comp:	mov ax, WORD PTR es:[bx+si]  ;Compares memory to bytes of this
	cmp ax, WORD PTR cs:[bx+si]  ;program.
	jne Nope		     ;If not equal, skip and keep searching.
	inc bx
	inc bx
	cmp bx,28h		     ;Has it reached 40 bytes equal?
	jne Comp
	mov al, BYTE PTR es:Timer    ;If so, check if that Dazzle is
	cmp al,04h		     ;inactive or active.
	jbe Failed		     ;if active, then exit to 'Failed'
Nope:	inc dx
	cmp dx, 0ffc0h		     ;Did it reach the end of the megabyte.
	jb Check		     ;Go back to beginning of loop.

Good:	mov dx, OFFSET Dazzle	    ;Dazzle installation.
	mov ax,0251Ch		    ;Request change of Timer interrupt 1Ch's
	int 21h 		    ;vector.
	mov dx, OFFSET Success	    ;Print Dazzle installed message
	mov ah,09h
	int 21h
	mov dx, OFFSET EndDazzle    ;Calculate the size of the resident
	mov cl,04h		    ;part, in paragraphs.
	shr dx,cl
	inc dx
	mov ax,03100h		    ;Terminate and Stay Resident
	int 21h

Failed:	mov dx, OFFSET Fail	    ;Error message indicating that Dazzle
	mov ah,09h		    ;was previously installed, and exit.
	int 21h
	mov ah,4Ch
	int 21h

END
