'This program requires the use of the QB.LIB / QB.QLB libraries.
DECLARE SUB FindFirstF (FileName$, Attr%)
DECLARE SUB CreateTree ()
DECLARE SUB WarnCompile ()
DECLARE SUB MChangeDrive (Old$, New$)
DECLARE SUB ScanTree (ScanPath$)
DECLARE FUNCTION CheckDrive% (New%)
DECLARE FUNCTION GetCurrDir$ ()
DECLARE FUNCTION GetCurrDrive$ ()
DECLARE FUNCTION Valid% (ValidDr%)

TYPE RegTypeX
	ax    AS INTEGER
	bx    AS INTEGER
	cx    AS INTEGER
	dx    AS INTEGER
	bp    AS INTEGER
	si    AS INTEGER
	di    AS INTEGER
	flags AS INTEGER
	ds    AS INTEGER
	es    AS INTEGER
END TYPE
TYPE DTA
	UnDoc    AS STRING * 21
	Attr     AS INTEGER
	Other    AS STRING * 7
	FileName AS STRING * 13
	Extra    AS STRING * 22
END TYPE
DECLARE SUB INTERRUPTX (Intnum%, Inreg AS RegTypeX, Outreg AS RegTypeX)
CONST TreeFileName$ = "TREEINFO.GO"
CONST DrivesFileName$ = "DRIVES.GO"
CONST LowDrive% = 1
CONST MaxDrive% = 32
CONST BuffLen% = 8192
DIM SHARED RegsX AS RegTypeX
DIM SHARED ValidDrive%(MaxDrive%)
DIM SHARED CurrDir AS STRING * 70
DIM SHARED DTAblock AS DTA
DIM SHARED entry%, Erred%, EnvGo%
DIM SHARED CurrDr%, HiDrive%
DIM SHARED Compile%
DIM SHARED CRLF$, ListDir$, Treeinfo$, Drives$

CRLF$ = CHR$(13) + CHR$(10)
CurrDrive$ = GetCurrDrive$
Curr$ = CurrDrive$ + ":\" + GetCurrDir$
Parm$ = " " + LTRIM$(RTRIM$(COMMAND$)) + " "
Opt$ = ""
Done% = 0
Temp% = INSTR(Parm$, " /")
DO WHILE Temp%
	SpcOffs% = INSTR(Temp% + 1, Parm$, " ")
	Opt$ = Opt$ + MID$(Parm$, Temp%, SpcOffs% - Temp%) + " "
	Parm$ = LEFT$(Parm$, Temp% - 1) + MID$(Parm$, SpcOffs%) + " "
	Temp% = INSTR(Parm$, " /")
LOOP
Parm$ = LTRIM$(RTRIM$(Parm$))
ParmLen% = LEN(Parm$)
IF INSTR(Opt$ + Parm$, "?") OR LEN(Opt$ + Parm$) = 0 THEN
	PRINT "GO Version 1.25 programmed by Mark D. Rejhon, Additions by Michael Habicher."
	PRINT "Quick dir change command with fast dir structure compilation!  Support for all"
	PRINT "non-removeable disks from A: thru Z:!  Command Line parameters help below:"
	PRINT
	PRINT "  GO <keyword> [?] [/C[d]] [/K]"
	PRINT "  <keyword>...A directory name, full or partial!"
	PRINT "  /?..........Displays this help screen."
	PRINT "  /C[d].......Compiles TREEINFO.GO.  Optional 'd' switch is the drive to put"
	PRINT "              this file on. (normally automatic or by environment variable)"
	PRINT "  /D[drives]..Scan only specific drives.  Used with the /C option above, it is"
	PRINT "              saved into a DRIVES.GO config file for the next compilation."
	PRINT "              Example /Dcf would tell GO to scan only the drives C: and F:."
	PRINT "  /K..........Scan by inner substring immediately, ie '16' for 'D:\AREA16'"
	PRINT "              The /K option may not always be necessary for such directories."
	PRINT
	PRINT "  GO saves keypresses over the 'CD' command.  You just type a full or partial"
	PRINT "  directory name and GO will automatically move you there!  Examples follow:"
	PRINT
	PRINT "  GO DOW            Moves you to D:\COMM\DOWNLOAD directory."
	PRINT "  GO DR             Moves you to C:\UTIL\DRIVER directory."
	PRINT "  GO ..\TE          Moves you to the ..\TELEMATE directory."
	PRINT "  GO ...            Same as doing CD .. two times"
	PRINT "  GO ....           Same as doing CD .. three times (and so on)"
	END
END IF
First% = 0
ON ERROR GOTO Whoops
FOR Drive% = LowDrive% TO HiDrive%
	IF Valid%(Drive%) THEN First% = Drive%: EXIT FOR
NEXT Drive%
IF First% = 0 THEN
	PRINT "FATAL ERROR: No Drives between "; CHR$(64 + LowDrive%); ": and "; CHR$(64 + HiDrive%); ": has been found!"
	PRINT "Sorry, this program cannot be used in this situation."
	END
END IF
Compile% = INSTR(Opt$, "/C")
IF LEN(ListDir$) = 0 THEN
	ListDir$ = UCASE$(LTRIM$(RTRIM$(ENVIRON$("GO"))))
	IF LEN(ListDir$) THEN IF Compile% THEN EnvGo% = -2 ELSE EnvGo% = -1
END IF
SelDrive% = INSTR(Opt$, "/D")
DriveList$ = ""
IF SelDrive% THEN
	DriveList$ = MID$(Opt$, SelDrive% + 2)
	IF INSTR(DriveList$, " ") THEN DriveList$ = LEFT$(DriveList$, INSTR(DriveList$, " ") - 1)
END IF
IF Compile% THEN
	DOpt$ = UCASE$(MID$(Opt$, Compile% + 2, 1))
	IF LEN(DOpt$) THEN
		Temp% = ASC(DOpt$) - 64
		IF Temp% >= 1 AND Temp% <= MaxDrive% THEN
			IF EnvGo% THEN
				PRINT "Environment variable 'GO' overrides the drive option for the /C parameter."
				PRINT "Please either erase the environment variable or omit the drive option."
				PRINT "For example, type only 'GO /C'."
				END
			ELSEIF CheckDrive%(Temp%) = 0 THEN
				PRINT "Please specify another drive to compile the tree information file on, or omit"
				PRINT "the drive option. This will cause this program replace the old "; TreeFileName$
				PRINT "file or create one in the root directory of an automatically selected drive."
				END
			END IF
			ListDir$ = DOpt$ + ":\"
		END IF
	END IF
END IF
IF LEN(ListDir$) THEN
	ListDir$ = LTRIM$(RTRIM$(UCASE$(ListDir$)))
	IF LEN(ListDir$) = 1 THEN
		IF ListDir$ <> ":" THEN ListDir$ = ListDir$ + ":\"
	ELSE
		IF RIGHT$(ListDir$, 1) <> "\" THEN ListDir$ = ListDir$ + "\"
	END IF
END IF
IF EnvGo% THEN
	FindFirstF ListDir$ + TreeFileName$, 255
	IF RegsX.flags AND 1 THEN Compile% = -1    'CF set if file nonexistent
END IF
IF LEN(ListDir$) = 0 THEN
	FOR Drive% = LowDrive% TO HiDrive%
		IF Valid%(Drive%) THEN
			Erred% = 0
			ListDir$ = CHR$(64 + Drive%) + ":\"
			FindFirstF ListDir$ + TreeFileName$, 255
			IF (RegsX.flags AND 1) = 0 THEN EXIT FOR
		END IF
	NEXT Drive%
	IF Drive% > HiDrive% THEN
		ListDir$ = CHR$(First% + 64) + ":\"
		Compile% = -1
	END IF
END IF
Erred% = 0
Treeinfo$ = UCASE$(ListDir$ + TreeFileName$)
Drives$ = UCASE$(ListDir$ + DrivesFileName$)
IF Compile% THEN
	IF SelDrive% THEN
		KILL Drives$
		IF LEN(DriveList$) THEN
			OPEN Drives$ FOR BINARY AS #2
			Linez$ = DriveList$ + CRLF$
			PUT #2, 1, Linez$
			CLOSE #2
		END IF
	END IF
	DIM SHARED TestPref$, Buffer$
	CreateTree
	PRINT "Tree information file has been compiled with"; entry%; "directories."
END IF
SELECT CASE Parm$
CASE "", ".": END
CASE "\":     CHDIR "\": END
END SELECT
IF LEFT$(Parm$, 1) = "." THEN
	DO WHILE LEFT$(Parm$, 2) = ".."
		CHDIR ".."
		Parm$ = MID$(Parm$, 2)
	LOOP
	Parm$ = MID$(Parm$, 3)
	IF LEN(Parm$) = 0 THEN END
	Curr$ = CurrDrive$ + ":\" + GetCurrDir$
	IF RIGHT$(Curr$, 1) = "\" THEN Parm$ = Curr$ + Parm$ ELSE Parm$ = Curr$ + "\" + Parm$
END IF
IF ParmLen% = 2 OR ParmLen% = 3 THEN
	IF RIGHT$(Parm$, ParmLen% - 1) = LEFT$(":\", ParmLen% - 1) THEN
		DOpt$ = UCASE$(LEFT$(Parm$, 1))
		NewDrive% = ASC(DOpt$) - 64
		IF CheckDrive%(NewDrive%) THEN
			MChangeDrive CurrDrive$, DOpt$
			IF ParmLen% = 3 THEN CHDIR "\"
		END IF
		END
	END IF
END IF
ON ERROR GOTO Ouch
OPEN ListDir$ + TreeFileName$ FOR BINARY AS #1 LEN = BuffLen%
Buff$ = SPACE$(BuffLen%)
GET #1, , Buff$
SubStr$ = ""
Pt% = -1
DO
	OldPt% = Pt% + 2
	Pt% = INSTR(OldPt%, Buff$, CHR$(13))
	IF Pt% THEN
		Path$ = MID$(Buff$, OldPt%, Pt% - OldPt%)
	ELSE
		IF EOF(1) THEN EXIT DO
		Path$ = MID$(Buff$, OldPt%)
		GET #1, , Buff$
		Pt% = INSTR(Buff$, CHR$(13))
		IF Pt% = 0 THEN EXIT DO
		Path$ = Path$ + LEFT$(Buff$, Pt% - 1)
	END IF
LOOP UNTIL Curr$ = Path$
IF Curr$ <> Path$ THEN
	PRINT "(Previous directory isn't in "; TreeFileName$; ")"
	Curr$ = Path$
END IF
Erred% = 0
IF INSTR(Parm$, "\") THEN
	Zap% = -2
ELSEIF INSTR(Opt$, "/K") THEN
	Zap% = -1
ELSE
	Zap% = 0
END IF
Yes% = 0
DO
	OldPt% = Pt% + 2
	Pt% = INSTR(OldPt%, Buff$, CHR$(13))
	IF Pt% THEN
		Path$ = MID$(Buff$, OldPt%, Pt% - OldPt%)
	ELSE
		IF EOF(1) THEN
			IF LOF(1) > BuffLen% THEN SEEK #1, 1
			Path$ = ""
		ELSE
			Path$ = MID$(Buff$, OldPt%)
		END IF
		IF LOF(1) > BuffLen% THEN GET #1, , Buff$
		Pt% = INSTR(Buff$, CHR$(13))
		IF Pt% = 0 THEN EXIT DO
		Path$ = Path$ + LEFT$(Buff$, Pt% - 1)
	END IF
	Temp% = INSTR(Path$, Parm$)
	IF Temp% THEN
		IF INSTR(Temp% + LEN(Parm$), Path$, "\") = 0 THEN
			IF Temp% = 1 THEN
				Yes% = -1: EXIT DO
			ELSEIF MID$(Path$, Temp% - 1, 1) = "\" THEN
				Yes% = -1: EXIT DO
			ELSE
				IF LEN(SubStr$) = 0 THEN SubStr$ = Path$: IF Zap% THEN Yes% = -1: EXIT DO
			END IF
		END IF
	END IF
LOOP UNTIL Path$ = Curr$
Erred% = 0
IF Yes% = 0 THEN IF LEN(SubStr$) THEN Path$ = SubStr$ ELSE Erred% = -1
IF Erred% THEN
	PRINT "GO: No match was found in the tree information file."
	END
END IF
Testit:
ON ERROR GOTO Whoops
CHDIR Path$
IF Erred% THEN
	PRINT
	PRINT Path$
	PRINT "ERROR found in "; TreeFileName$; ": ";
	ErrDrive% = ASC(UCASE$(LEFT$(Path$, 1))) - 64
	IF ErrDrive% < 1 OR ErrDrive% > 26 THEN
		PRINT "An unrecognized entry was found!"
		WarnCompile
		END
	ELSEIF Valid%(ErrDrive%) = 0 THEN
		PRINT "Drive "; UCASE$(LEFT$(Path$, 1)); ": does not exist!"
		WarnCompile
		END
	END IF
	PRINT "Directory does not exist."
	WarnCompile
	END
END IF
MChangeDrive CurrDrive$, LEFT$(Path$, 1)
IF ReComp% THEN WarnCompile
END

'The following is for error trapping
Whoops:
Erred% = -1
RESUME NEXT

Ouch:
PRINT "ERROR: There was a problem in reading the "; TreeFileName$; " file."
WarnCompile
END

FUNCTION CheckDrive% (New%)
	IF New% < LowDrive% OR New% > MaxDrive% THEN
		PRINT "ERROR: Drive "; CHR$(New% + 64); ": is not supported by this program!"
	ELSEIF Valid%(New%) = 0 THEN
		PRINT "ERROR: Drive "; CHR$(New% + 64); ": does not exist!"
	ELSE
		CheckDrive% = -1
	END IF
END FUNCTION

SUB CreateTree
	FOR Drive% = LowDrive% TO HiDrive%
		IF Valid%(Drive%) THEN
			Drv$ = CHR$(64 + Drive%) + ":\"
			IF Drv$ <> ListDir$ THEN KILL Drv$ + DrivesFileName$
			KILL Drv$ + TreeFileName$
		END IF
	NEXT Drive%
	Erred% = 0
	FindFirstF Treeinfo$, 255
	IF (RegsX.flags AND 1) = 0 THEN
		KILL Treeinfo$
	ELSE
		IF EnvGo% THEN PRINT : PRINT "The "; TreeFileName$; " file, as located by the environment variable GO, does not exist!"
	END IF
	IF Erred% = 0 THEN OPEN Treeinfo$ FOR BINARY AS #1 LEN = BuffLen%
	IF Erred% THEN
		PRINT
		PRINT Treeinfo$
		PRINT "ERROR: This tree information file could not be opened."
		IF Er% = 0 THEN
			PRINT "The file is either locked or is a directory name."
		ELSE
			IF EnvGo% THEN
				PRINT "The environment variable GO may have an error, and may need to be fixed."
			ELSE
				PRINT "Try making sure that this file can be created, or try specifying another"
				PRINT "drive to compile the tree information file on."
			END IF
		END IF
		END
	ELSE
		PRINT "Compiling "; Treeinfo$; " directory tree information file..."
	END IF
	FindFirstF Drives$, 255
	IF (RegsX.flags AND 1) = 0 THEN
		OPEN Drives$ FOR BINARY AS #2
		DriveList$ = SPACE$(128)
		GET #2, 1, DriveList$
		DriveList$ = UCASE$(LEFT$(DriveList$, INSTR(DriveList$, CRLF$) - 1))
		CLOSE #2
	END IF
	SEEK #1, 1
	RegsX.ax = &H1A00
	RegsX.ds = VARSEG(DTAblock)
	RegsX.dx = VARPTR(DTAblock)
	INTERRUPTX &H21, RegsX, RegsX
	FOR Drive% = LowDrive% TO HiDrive%
		IF Valid%(Drive%) THEN
			Drv$ = CHR$(64 + Drive%)
			IF LEN(DriveList$) = 0 OR INSTR(DriveList$, Drv$) <> 0 THEN
				TestPref$ = Drv$ + ":\"
				PRINT LEFT$(TestPref$ + SPACE$(70), 70);
				LOCATE , 1
				Buffer$ = Buffer$ + TestPref$ + CRLF$
				ScanTree ""
			END IF
		END IF
	NEXT Drive%
	PUT #1, , Buffer$
	CLOSE #1
END SUB

SUB FindFirstF (FileName$, Attr%)
	CurrDir = FileName$ + CHR$(0)
	RegsX.ax = &H4E00
	RegsX.cx = Attr%
	RegsX.ds = VARSEG(CurrDir)
	RegsX.dx = VARPTR(CurrDir)
	INTERRUPTX &H21, RegsX, RegsX
END SUB

FUNCTION GetCurrDir$
	RegsX.ax = &H4700
	RegsX.dx = &H0
	RegsX.ds = VARSEG(CurrDir$)
	RegsX.si = VARPTR(CurrDir$)
	INTERRUPTX &H21, RegsX, RegsX
	GetCurrDir$ = LEFT$(CurrDir$, INSTR(CurrDir$, CHR$(0)) - 1)
END FUNCTION

FUNCTION GetCurrDrive$
	RegsX.ax = &H1900
	INTERRUPTX &H21, RegsX, RegsX
	CurrDr% = RegsX.ax AND 255
	GetCurrDrive$ = CHR$((65 + CurrDr%) AND 255)
	IF HiDrive% = 0 THEN
		RegsX.ax = &HE00
		RegsX.dx = CurrDr%
		INTERRUPTX &H21, RegsX, RegsX
		HiDrive% = RegsX.ax AND 255
		IF HiDrive% > MaxDrive% THEN
			HiDrive% = MaxDrive%
		ELSEIF HiDrive% < LowDrive% THEN
			HiDrive% = LowDrive%
		END IF
	END IF
END FUNCTION

SUB MChangeDrive (Old$, New$)
	New$ = UCASE$(New$)
	IF New$ <> LCASE$(New$) AND Old$ <> New$ THEN
		RegsX.ax = &HE00
		RegsX.dx = ASC(New$) - 65
		INTERRUPTX &H21, RegsX, RegsX
	END IF
END SUB

SUB ScanTree (ScanPath$)
	DIM DTAsave AS DTA
	FindFirstF TestPref$ + ScanPath$ + "*.*", 18
	IF ASC(DTAblock.FileName) = 46 THEN        'Skips . and ..
		RegsX.ax = &H4F00
		INTERRUPTX &H21, RegsX, RegsX
		RegsX.ax = &H4F00
		INTERRUPTX &H21, RegsX, RegsX
	END IF
	DO UNTIL RegsX.flags AND 1        'CF flag set if no more files in dir
		IF DTAblock.Attr AND 16 THEN    'Check Directory attribute
			entry% = entry% + 1
			DirName$ = LEFT$(DTAblock.FileName, INSTR(DTAblock.FileName, CHR$(0)) - 1)
			Temp$ = TestPref$ + ScanPath$ + DirName$
			Buffer$ = Buffer$ + Temp$ + CRLF$
			IF LEN(Buffer$) > BuffLen% THEN
				Buff$ = LEFT$(Buffer$, BuffLen%)
				PUT #1, , Buff$
				Buff$ = ""
				Buffer$ = MID$(Buffer$, BuffLen% + 1)
			END IF
			PRINT LEFT$(Temp$ + SPACE$(70), 70);
			LOCATE , 1
			DTAsave = DTAblock                    'Saves current dir position
			ScanTree ScanPath$ + DirName$ + "\"   'Recursive call
			DTAblock = DTAsave                    'Restores previous position
		END IF
		RegsX.ax = &H4F00
		INTERRUPTX &H21, RegsX, RegsX     'Finds next file
	LOOP
	Key$ = INKEY$
	IF Key$ = CHR$(27) OR Key$ = CHR$(3) THEN
		PRINT LEFT$("Compilation aborted by user." + SPACE$(70), 70)
		CLOSE #1
		KILL ListDir$ + TreeFileName$
		END
	END IF
END SUB

FUNCTION Valid% (ValidDr%)
'Returns 0 if not removable, -1 if removable, and 14 if invalid.
'This subroutine was inspired by Mike Habitcher for Mark Rejhon
'in the upgrade from GO version 1.20 to GO version 1.21.

	IF ValidDrive%(ValidDr%) THEN Valid% = -1: EXIT FUNCTION
	RegsX.ax = &H4408                     'IOCTL sub-function &H08.
	RegsX.bx = ValidDr%                   'Drive to test.
	INTERRUPTX &H21, RegsX, RegsX         'Make DOS call.
	IF RegsX.ax = 1 THEN
		ValidDrive%(ValidDr%) = -1
		Valid% = -1
	END IF

END FUNCTION

SUB WarnCompile
	IF Compile% = 0 THEN PRINT "You may need to recompile the "; TreeFileName$; " file with the /C option."
END SUB

