'1991 by Viddy-Oh soft!
'
'  This mars landscape viewer was made by Mark D. Rejhon on August 12th,
'13th, in about 6 hours' worth of experimenting. (not counting the loss
'caused by a computer lock-up that occured while I was typing comments
'into this program) after looking at MARSFACE.TXT for several minutes,
'after I downloaded it into my computer. I programmed this viewer out of
'interest in challenge, versus a friend.
'
'  The hex numbers data file, MARSFACE.DAT, edited from MARSFACE.TXT,
'contains the data for the graphics picture. Two pictures are contained
'in these files, derived from high resolution images taken by a space
'probe that went to Mars. There are approximately 800 lines of hex
'numbers in this file. About 400 lines of hex numbers per picture.
'There are 50 hex digits per line. It was specified in MARSFACE.TXT that
'there were 4 lines of hex numbers per scan line of picture, for 200
'hex digits per scan line of picture.
'
'  In the making of this program, I first decided to use false color
'(using the standard IBM color palette, for simplicity) using 1 pixel per
'hex number, in the all-so-standard raster fashion. That caused a rough
'indication of some hill or crater to materialize on the screen, (it's
'hard to tell at the low resolution) with alternating one pixel-width
'disctint vertical lines contrasting from each other. The resolution was
'200 horizontally and 100 vertically. That told me the images were 2 hex
'numbers per pixel, for 256 available colors. I modified this program
'slightly. The final resolutions for the picture stood at 100 by 100,
'which is equal to what was mentioned in MARSFACE.TXT.
'
'  On August the 13th, I debugged this program of minor bugs, and found that
'a greyshade photograph style image materialized when I set the VGA palette
'to a smooth blend of greyshades from black into white. I made a test
'to add up the number of times each color attribute was used. It apparently
'turns out that only even hex numbers were used, narrowing the number of
'possible colors down to 128. There was a lot of noise in the unfiltered
'picture, and I decided I'd try make a few tests.
'
'  The even color attributes between 52 and 112 had a surge, being used
'tens, even hundreds of times. Outside the range, at even numbers between
'0 and 50, and between 114 and 254, almost all these color attributes had
'less than 10 pixels in the two pictures. So I decided to make a bandwidth
'filter that would check all the pixel's color attribute value, and filter
'out all of the pixels that are not within attributes 52 and 114, by
'replacing those pixels with the average color attribute from the
'surrounding pixel above, below, left and right.
'  That resulted in two much improved pictures. But there were still some
'noise. For about 2 hours, I experimented with some techniques, on how
'to detect pixels that contrasted too sharply from surrounding pixels.
'For all non-border pixels, I finally decided to average the 8 surrounding
'pixels around each pixel, and check the difference of the middle pixel and
'the average of its surrounding pixels. If it exceeded the value in the
'"maxpref" variable, the middle pixel is replaced by the average color of
'the 8 surrounding pixels. That greatly eliminated noise further with
'minimum distortion, when I chose 7 for the "maxpref" variable. This
'filter is probably a version of the smart gradation filter, reinvented.
'  When I used the gradation filter without the pre-filter with the
'bandwidth filter, there was a lot of distortion. It was probably due to
'the "noise" pixels in the surrounding 8 pixels around a non-noise middle
'pixel, offesetting the average of the surrouding 8 pixels. It results
'in a distortion of the rightful color attribute of that middle pixel.
'
'  In brief, the two pictures are plot raw, right out of the MARSFACE.DAT
'hex numbers data file, in a raster-style fashion. Then the bandwidth
'filter filters out the the pixels outside the range of majority color
'attributes that the image uses. The bandwidth filter goes relatively
'quickly. Next, the gradation filter filters out pixels that contrasts
'too heavily from its surrounding 8 pixels. The gradation filter goes
'fairly slow, but otherwise efficiently.
'
'
'Specifications:
'    Number of text rows per scan line: 4
'            Number of colors possible: 128
'  Approx. number colors actually used: 31
'                   Number of pictures: 2
'     Resolution per picture in pixels: 100 x 100
'                   Color palette used: greyshades
'                         Filters used: bandwidth and gradation
'

DEFINT A-Z          'Defines variables integer as the default type.

'The following defines the functions and subroutines used in this program.
DECLARE FUNCTION Textline$ ()
DECLARE SUB palet (Colour%, Red%, Green%, Blue%)

SCREEN 13       'Sets the 256-color VGA video mode with 320 x 200
                'pixel resolution.
                                                                
'The following three FOR loops sets the greyshade palette to be used
'for the two pictures of the Mars surface.
FOR initpalet = 0 TO 31             'This loop sets the color attributes
  palet initpalet, 0, 0, 0          '0 to 31 to black.
NEXT initpalet
FOR initpalet = 32 TO 159           'This loop assigns shades of grey
  col = INT((initpalet - 32) / 2)   'smoothly blending from black in color
  palet initpalet, col, col, col    'attribute 32 to white in color
NEXT initpalet                      'attribute 159.
FOR initpalet = 160 TO 255          'This loops sets the color attributes
  palet initpalet, 63, 63, 63       '160 to 255 to white.
NEXT initpalet


DIM colocc(255)           'Color occurence flags.

'The following statement opens the hex numbers data file for the 2 pictures.
OPEN "marsface.dat" FOR INPUT AS #1

'"Xoffs" is the horizontal offset of the left border of the picture from
'the left border of the screen. "Yoffs" is the vertical offset of the top
'border of the picture from the top border of the screen. "linelen" is
'the width of the picture in actual VGA video mode pixels. "maxpref" is
'for the gradation filter subroutine, and represents the maximum difference
'(contrast) a pixel may have from the average of its surrounding pixels.
'"lower" and "upper" is for the bandwidth filter and represents the
'allowable range of color attributes within the picture.
CONST Xoffs = 100
CONST Yoffs = 0
CONST linelen = 200
CONST maxpref = 7
CONST lower = 52
CONST upper = 112

linenum = 0         'The scan line number counter.

'This loop plots the picture on the screen.
Erred% = 0
ON ERROR GOTO SomeErr          'Enables error checking for end of file
DO
  'Reads 4 lines from the text file.
  INPUT #1, lineone$, linetwo$, linethree$, linefour$

  'The following line merges all 4 lines of hex numbers into one string
  'of 200 hex numbers.
  scanline$ = lineone$ + linetwo$ + linethree$ + linefour$
 
  'This loop plots a scan line of the picture onto the screen.
  'The statement for variable "value" uses the VAL function to convert a
  'two digit hex number into a decimal value. The two statements with PSET
  'plots a double width pixel on the screen of color attribute "value".
  'Variables "plotit" is the column and "linenum" is the scan line.
  FOR plotit = 1 TO linelen STEP 2
    value = VAL("&H" + MID$(scanline$, plotit, 2))
    colocc(value) = colocc(value) + 1
    PSET (Xoffs + plotit - 1, Yoffs + linenum), value
    PSET (Xoffs + plotit, Yoffs + linenum), value
  NEXT plotit

  linenum = linenum + 1     'Increments the scan line number counter.
LOOP UNTIL Erred%           'loops until the end of the text file is reached.
ON ERROR GOTO 0

'The following is the bandwidth filter routine. These two loops checks
'each pixel in a raster style fashion. The function POINT reads the color
'attribute of a pixel on the screen, and the command PSET plots a pixel
'of a color attribute.
FOR vert = 0 TO linenum - 1                'loop for scan line.
  FOR horiz = 0 TO linelen - 2 STEP 2      'loop for column.
    'The below assigns "col" the color attribute of the current pixel.
    col = POINT(Xoffs + horiz, Yoffs + vert)

    'Is "col" outside the allowable range? If so, the below gathers the
    'color attributes of the surrounding 4 pixels around the current pixel
    'then assigns "average" the average of these pixels. Next, the current
    'pixel is replaced by color attribute "average".
    IF col < 52 OR col > 112 THEN
      left = POINT(Xoffs + horiz - 2, Yoffs + vert)
      right = POINT(Xoffs + horiz + 2, Yoffs + vert)
      above = POINT(Xoffs + horiz, Yoffs + vert - 1)
      below = POINT(Xoffs + horiz, Yoffs + vert + 1)
      average = (left + right + above + below) / 4
      PSET (Xoffs + horiz, Yoffs + vert), average
      PSET (Xoffs + horiz + 1, Yoffs + vert), average
    END IF
  NEXT horiz       'next column.
NEXT vert          'next scan line.

'The following is the gradation filter subroutine. The two loops below
'checks each non-border pixels in a raster-style fashion.
FOR vert = 0 TO linenum - 3                   'loop for scan line.
  FOR horiz = 0 TO linelen - 6 STEP 2         'loop for column.
    'The below assigns "col" the color attribute of the current pixel.
    col = POINT(Xoffs + horiz + 2, Yoffs + vert + 1)

    'The nested loop below gathers the total of the color attributes of
    'the 3 x 3 block of pixels, in which the current pixel is the middle.
    total = 0
    FOR xs = 0 TO 2
      FOR ys = 0 TO 2
        total = total + POINT(Xoffs + horiz + xs * 2, Yoffs + vert + ys)
      NEXT ys
    NEXT xs

    'The below removes the middle pixel from the total above and calculates
    'the average color attribute.
    average = (total - col) / 8

    'If the current pixel contrasts from the average by more than the value
    'in "maxpref", the current pixel is replaced with the average.
    IF ABS(col - average) > maxpref THEN
      'LINE (Xoffs + horiz + 2, Yoffs + vert + 1)-(Xoffs + horiz + 3, Yoffs + vert + 1), , BF
      PSET (Xoffs + horiz + 2, Yoffs + vert + 1), average
      PSET (Xoffs + horiz + 3, Yoffs + vert + 1), average
    END IF
  NEXT horiz         'next column.
NEXT vert            'next scan line.

'The following locates the cursor on the 7th row of the screen, sets the
'cursor to color attribute 15, which is white according to the standard
'VGA palette. Then it prints out this program's name, the date and programmer
'(me, Mark Rejhon), and then prompts the user to press a key. The SLEEP
'statement waits for the user to press a key.
LOCATE 6
COLOR 255
PRINT "Mars"
PRINT " landscape"
PRINT "  viewer"
PRINT "   with"
PRINT "    filter"
PRINT
PRINT "Aug 1991 by"
PRINT " Mark D."
PRINT "  Rejhon"
PRINT
PRINT "Press"
PRINT " any"
PRINT "  key!"
SLEEP

END
SomeErr:
Erred% = -1
RESUME NEXT

SUB palet (Colour, Red, Green, Blue)
'This subroutine sets a color attribute to a palette by red, green
'and blue intensities. Pixels of that color attribute would have a hue
'and brightness from the additive mix of Red, Green, and Blue.
'>Parameters:
'Colour :the color attribute number, 0 to 255.
'Red    :the intensity of the red component, 0 to 63.
'Green  :the intensity of the green component, 0 to 63.
'Blue   :the intensity of the blue component, 0 to 63.

 PALETTE Colour, Blue * 65536 + Green * 256 + Red
END SUB

