'----------------------------------------------------------------------------
' QuickBASIC program by Mark D. Rejhon programmed in 1992
' Updated in 1997 by Mark D. Rejhon again.
' Released into the public domain.  Help yourself.
' Compatible with MSDOS QBASIC.
' Note: This is crappy programming style, but this is a quick hack ;-)

DEFINT A-Z

'----------------------------------------------------------------------------
' The following is leftover code from an old program that I'd thought I'd
' keep for a nicer looking screen. :)

SCREEN 13
VIEW PRINT 1 TO 25
FOR Ln% = 0 TO 319
  LINE (Ln%, 0)-(Ln%, 22), (Ln% MOD 255), BF
NEXT Ln%

'----------------------------------------------------------------------------
'The following calculates the refresh speed of the display in current
'video mode.  It counts the number of vertical blanking intervals
'that occurs in 10 seconds.

TestLen# = 10
RefreshCount# = 0
LOCATE 4
PRINT "Calculating approx refresh rate..."
PRINT "Please wait 10 seconds."
PRINT
PRINT "NOTE:"
PRINT "Best to run this in native DOS mode."
PRINT "Or without any apps in the background."
' DOS timer is too granular at 1/18.2.  Synchronize to next tick.
Test! = TIMER: DO: LOOP UNTIL TIMER <> Test!
'Start counting refreshes for 10 seconds.
Test! = TIMER
DO
  WAIT &H3DA, 8
  WAIT &H3DA, 8, 8
  RefreshCount# = RefreshCount# + 1
LOOP UNTIL (TIMER - Test!) >= TestLen#
FPS = CINT(RefreshCount# / TestLen#)

'----------------------------------------------------------------------------
' When running in windowed mode, the vertical blanking interval cannot
' be detected from DOS and will produce inaccurate results, so this is
' a safeguard.

LOCATE 4
PRINT SPACE$(39);
PRINT SPACE$(39);
PRINT SPACE$(39);
PRINT SPACE$(39);
PRINT SPACE$(39);
PRINT SPACE$(39);
PRINT SPACE$(39);
PRINT SPACE$(39);
LOCATE 4
IF (FPS > 200) OR (FPS < 30) THEN
  PRINT "Error: Refresh value outside range."
  PRINT "Please run this in full screen mode"
  PRINT "or in native MS-DOS mode."
  PRINT
  PRINT "Press any key..."
  DO: LOOP UNTIL LEN(INKEY$)
  SCREEN 0
  END  'Quick Exit Kludge
END IF
PRINT "Refresh speed is approx"; FPS; "Hz.       "
PRINT "Demo of edge solidness during motion."

'----------------------------------------------------------------------------
'The following displays the flicker speeds.

FOR a = 0 TO 3
  LOCATE 12 + a * 4, 35
  PRINT USING "##.#Hz"; FPS / (a + 1);
NEXT

'----------------------------------------------------------------------------
'The following are variables for speedy drawing on the screen.
lt1 = 0
lt2 = 0
lt3 = 0
lt4 = 0
wid = 30
col1 = 0
col2 = 15
counter = 0
ht = 32
ed = 225
top1 = 72 + ht * 0
top2 = 72 + ht * 1
top3 = 72 + ht * 2
top4 = 72 + ht * 3
xs1 = 4
xs2 = xs1 * 2
xs3 = xs1 * 3
xs4 = xs1 * 4
bot = 30

'----------------------------------------------------------------------------
' This is the loop that does a side by side animation of squares.
DO
  'This is a wraparound counter that goes from 0 to 31 and then back to 0.
  counter = (counter + 1) AND 31

  'For superfast computers, the following waits blanking interval to end.
  WAIT &H3DA, 8, 8
  'The following waits for a vertical blanking interval.
  WAIT &H3DA, 8
 
  'This is redrawn full frame rate.
  LINE (lt1, top1)-(lt1 + wid, top1 + bot), col1, BF
  lt1 = lt1 + xs1
  IF lt1 >= ed OR lt1 <= 0 THEN xs1 = -xs1   'Reverse direction if necessary
  LINE (lt1, top1)-(lt1 + wid, top1 + bot), col2, BF

  'This is redrawn at half frame rate.
  LINE (lt2, top2)-(lt2 + wid, top2 + bot), col1, BF
  lt2 = lt1 - (lt1 MOD xs2)
  LINE (lt2, top2)-(lt2 + wid, top2 + bot), col2, BF
 
  'This is redrawn at third frame rate.
  LINE (lt3, top3)-(lt3 + wid, top3 + bot), col1, BF
  lt3 = lt1 - (lt1 MOD xs3)
  LINE (lt3, top3)-(lt3 + wid, top3 + bot), col2, BF
 
  'This is redrawn at quarter frame rate.
  LINE (lt4, top4)-(lt4 + wid, top4 + bot), col1, BF
  lt4 = lt1 - (lt1 MOD xs4)
  LINE (lt4, top4)-(lt4 + wid, top4 + bot), col2, BF
 
LOOP UNTIL LEN(INKEY$)

'----------------------------------------------------------------------------
' Reset to text mode and exit.
SCREEN 0
END

