'$INCLUDE: 'SUPP.BI'
'
'Copyright 1994 by Mark D. Rejhon <marky@ottawa.com>
'All Rights Reserved.

DECLARE SUB AInit ()
DECLARE SUB Acompress (Astring$, SaveAns$)
DECLARE FUNCTION AColor$ (NewColor%)
DECLARE FUNCTION ALocate$ (OldRow%, OldCol%, NewRow%, NewCol%)
DECLARE FUNCTION ColorValue% ()
DECLARE FUNCTION ACode$ (FromRow%, FromCol%, NewRow%, NewCol%, NewColor%)

DIM SHARED Erred%
DIM SHARED ALine AS STRING * 280
DIM SHARED ARow%, ACol%, AFore%, ABack%, ATop%, ABot%
DIM SHARED AVirtRow%, AVirtCol%
DIM SHARED AWidth%, AHeight%       'Size of ANSI printing window.
DIM SHARED ANScolorForeStr$(7), ANScolorBackStr$(7)
DIM SHARED ANScolorTran%(7), ANSIattr$(1, 1, 1, 1)
DIM SHARED OldRow%, OldCol%, OldColor%, ExactLoc%, ColorKnown%
DIM SHARED Control$
DIM SHARED Linear%, Preserve%, FilterSpace%
DIM FileName$(1000)
CONST TRUE = -1, FALSE = 0, NEITHER = 2
CONST esc$ = "", escbr$ = "["
CONST ANSup$ = "[A", ANSdown$ = "[B", ANSleft$ = "[D", ANSright$ = "[C"
CONST ANSchars$ = "mABCDHfsuKJLM@Pnr;?0123456789" 'ANSI codes suffixes
CONST Amaxlength% = 8192
CONST BuffLen% = 8192
CONST Version$ = "1.00"

Parm$ = UCASE$(LTRIM$(RTRIM$(COMMAND$)))
IF LEN(Parm$) = 0 OR INSTR(Parm$, "?") THEN
  PRINT "ANSI file optimizer version 0.90 alpha"
  PRINT "Compresses ANSI files to smaller sizes without affecting their look!"
  PRINT "Programmed March 1994 by Mark D. Rejhon."
  PRINT
  PRINT "PACKANSI <filespec> [/L [/S]] [/Wxx] [/P] [/O]"
  PRINT
  PRINT "  <filespec>..The files with ANSI codes.  Must be in current directory."
  PRINT "  /L..........Linear ANSI (non-animated ANSI displaying in top-down order)"
  PRINT "              mode for better compression.  Lines are also ended with a"
  PRINT "              black background set, to make scrolling ANSIs look better."
  PRINT "              May have weird results on animated ANSIs.  Use at your own risk!"
  PRINT "  /S..........Compress spaces and invisible characters.  Must be used with"
  PRINT "              the /L option.  May not work on all animated ANSI's."
  PRINT "  /Wxx........The width of the ANSI (8-256).  Default is 80 columns."
  PRINT "  /P..........Preserve ANSI codes not recognized by PACKANSI. (very rare!)"
  PRINT "  /O..........Overwrite existing *.NEW output files."
  PRINT
  PRINT "OUTPUT: Optimized ANSI files get the suffix '.NEW' in current directory."
  PRINT "WARNING: This compressor may not work on all ANSI files and can actually"
  PRINT "         introduce defects.  Please carefully review the output files if"
  PRINT "         plan on replacing the original ANSI files!"
  PRINT "NO WARRANTY: This program comes with no warranty, and is only guaranteed"
  PRINT "             to use up space on your hard disk.  Use at your own risk!"
  END
END IF

Erred% = 0
ON ERROR GOTO Errorr
Parm$ = " " + COMMAND$ + " "
DO WHILE INSTR(Parm$, "/")
  Begin% = INSTR(Parm$, "/")
  Test1% = INSTR(Begin% + 1, Parm$, "/")
  Test2% = INSTR(Begin% + 1, Parm$, " ")
  IF Test1% < Test2% AND Test1% <> 0 THEN Test% = Test1% ELSE Test% = Test2%
  Switch$ = Switch$ + MID$(Parm$, Begin%, Test% - Begin%) + " "
  Parm$ = LEFT$(Parm$, Begin% - 1) + MID$(Parm$, Test%)
LOOP
IF INSTR(Switch$, "/L") THEN Linear% = TRUE
IF INSTR(Switch$, "/P") THEN Preserve% = TRUE
IF INSTR(Switch$, "/S") THEN FilterSpace% = TRUE
IF INSTR(Switch$, "/O") THEN OverWrite% = TRUE
IF INSTR(Switch$, "/W") THEN
  AWid% = VAL(MID$(Switch$, INSTR(Switch$, "/W") + 2))
END IF
FileSpec$ = LTRIM$(RTRIM$(Parm$))

IF INSTR(FileSpec$, ".") = 0 THEN FileSpec$ = FileSpec$ + ".ANS"
FindFirstF FileSpec$, 0, Erred%
IF Erred% THEN
  PRINT
  PRINT "ERROR: The specified filespec was invalid."
  PRINT "Type 'PACKANSI' alone at the prompt to get a command-line help screen."
  END
END IF
NumFiles% = 0
DO
  FileName$ = SPACE$(12)
  GetNameF FileName$, NameLen%
  NumFiles% = NumFiles% + 1
  FileName$(NumFiles%) = LEFT$(FileName$, NameLen%)
  FindNextF Erred%
LOOP UNTIL NumFiles% = 1000 OR Erred% <> 0
AInit
IF AWid% >= 8 AND AWid% <= 256 THEN AWidth% = AWid%

COLOR 7, 0
LOCATE , , 1, 6, 7
FOR DoFile% = 1 TO NumFiles%
  FileName$ = FileName$(DoFile%)
  PRINT FileName$; TAB(15);
  Dot% = INSTR(FileName$, ".")
  IF Dot% THEN
    OutFile$ = LEFT$(FileName$, Dot% - 1) + ".NEW"
  ELSE
    OutFile$ = FileName$ + ".NEW"
  END IF
  Erred% = 0
  CLOSE
  OPEN FileName$ FOR BINARY ACCESS READ AS #1 LEN = 1024
  IF Erred% THEN
    PRINT "Error opening file."
    END
  END IF
  IF (Exist2%(OutFile$) <> 0) AND (NOT OverWrite%) THEN
    PRINT "Output file exists: " + OutFile$
  ELSE
    IF OverWrite% THEN KILL OutFile$
    Erred% = 0
    OPEN OutFile$ FOR BINARY ACCESS WRITE AS #2 LEN = 1024
    IF Erred% THEN
      PRINT "Error opening output file: " + OutFile$
      END
    END IF
    OrigSize& = LOF(1)
    AFore% = 7
    ABack% = 0
    ARow% = 1
    ACol% = 1
    ATop% = 1
    ABot% = AHeight%
    OldRow% = 1
    OldCol% = 1
    OldColor% = -1
    ExactLoc% = FALSE       'Cursor pos in ARow% & ACol% isnt necessarily exact.
    ColorKnown% = FALSE     'Unknown color, as it is definite at the start.
    Ptr& = 1
    PRINT "Optimizing...";
    Loca% = POS(0)
    IF LOF(1) THEN
      DO
	Block$ = SPACE$(512)
	GET #1, , Block$
	IF EOF(1) THEN Block$ = LEFT$(Block$, LOF(1) - Ptr& + 1)
	Ptr& = Ptr& + LEN(Block$)
	Acompress Block$, SaveAns$
	IF EOF(1) THEN
	  SaveAns$ = SaveAns$ + AColor$(ColorValue%) + ALocate$(OldRow%, OldCol%, ARow%, ACol%) + AColor$(ColorValue%)
	END IF
	PUT #2, , SaveAns$
	LOCATE , Loca%
	PRINT USING "###.#%"; LOC(1) / LOF(1) * 100;
	Keyy$ = INKEY$
      LOOP UNTIL EOF(1) OR Keyy$ = CHR$(27) OR Keyy$ = CHR$(3)
    END IF
    NewSize& = LOF(2)
    CLOSE
    IF Keyy$ = esc$ OR Keyy$ = CHR$(3) THEN
      LOCATE , 14
      PRINT " Aborted.                                     "
      KILL OutFile$
      EXIT FOR
    ELSE
      LOCATE , 1
      PRINT FileName$;
      PRINT TAB(15); "New file: "; OutFile$; TAB(40);
      PRINT "Old"; STR$(OrigSize&); TAB(52); "New"; STR$(NewSize&); TAB(64); "Saved"; OrigSize& - NewSize&
    END IF
  END IF
NEXT
CLOSE
END

Errorr:
  Erred% = TRUE
  RESUME NEXT

FUNCTION ACode$ (FromRow%, FromCol%, NewRow%, NewCol%, NewColor%)
  'Find smallest code to change old cursor/attribs to new cursor loc/attribs
  'Because of the use of some color codes in the cursor movement code
  'routine at times, this function is useful.

  'Save 1st state
  S1Row% = OldRow%: S1Col% = OldCol%: S1Color% = OldColor%
  S1KnownC% = ColorKnown%: S1knownP% = ExactLoc%

  'Get first test code string.
  Test1$ = ALocate$(FromRow%, FromCol%, NewRow%, NewCol%) + AColor$(NewColor%)
  IF LEN(Test1$) = 0 THEN EXIT FUNCTION

  'Save 2nd state
  S2Row% = OldRow%: S2Col% = OldCol%: S2Color% = OldColor%
  S2knownC% = ColorKnown%: S2knownP% = ExactLoc%
 
  'Restore 1st state
  OldRow% = S1Row%: OldCol% = S1Col%: OldColor% = S1Color%
  ColorKnown% = S1KnownC%: ExactLoc% = S1knownP%

  'Get second test code string.
  Test2$ = AColor$(NewColor%) + ALocate$(FromRow%, FromCol%, NewRow%, NewCol%)
  
  'Determine shorter of test code string.
  IF LEN(Test2$) <= LEN(Test1$) AND NewColor% = OldColor% THEN
    ACode$ = Test2$
  ELSE
    ACode$ = Test1$
    OldRow% = S2Row%: OldCol% = S2Col%: OldColor% = S2Color%
    ColorKnown% = S2knownC%: ExactLoc% = S2knownP%
  END IF
 
END FUNCTION

FUNCTION AColor$ (NewColor%)
  IF ColorKnown% = FALSE OR (OldColor% = NewColor% AND ColorKnown% <> NEITHER) THEN EXIT FUNCTION
  NewBold% = (NewColor% AND 8) \ 8
  NewBlink% = NewColor% \ 128
  NewFore% = NewColor% AND 7
  NewBack% = NewColor% AND 112
  Colrs$ = ";0" + ANSIattr$(0, 0, NewBold%, NewBlink%)
  IF NewFore% <> 7 THEN Colrs$ = Colrs$ + ANScolorForeStr$(NewFore%)
  IF NewBack% <> 0 THEN Colrs$ = Colrs$ + ANScolorBackStr$(NewBack% \ 16)
  IF OldColor% <> -1 AND ColorKnown% = TRUE THEN
    OldBold% = (OldColor% AND 8) \ 8
    OldBlink% = OldColor% \ 128
    IF NewBold% >= OldBold% AND NewBlink% >= OldBlink% THEN
      Colr2$ = ANSIattr$(OldBold%, OldBlink%, NewBold%, NewBlink%)
      IF (OldColor% AND 7) <> NewFore% THEN Colr2$ = Colr2$ + ANScolorForeStr$(NewFore%)
      IF (OldColor% AND 112) <> NewBack% THEN Colr2$ = Colr2$ + ANScolorBackStr$(NewBack% \ 16)
      IF LEN(Colr2$) < LEN(Colrs$) THEN Colrs$ = Colr2$
    END IF
  END IF
  AColor$ = escbr$ + MID$(Colrs$, 2) + "m"
  OldColor% = NewColor%
  ColorKnown% = TRUE
END FUNCTION

SUB Acompress (Astring$, SaveAns$) STATIC
  IF Astring$ = "" THEN EXIT SUB
  SaveAns$ = ""
  ADisplay% = 1
  DO WHILE ADisplay% <= LEN(Astring$)
    IF (ANScode% OR AVTcode%) = 0 THEN
      DO WHILE ADisplay% <= LEN(Astring$)
	AChar$ = MID$(Astring$, ADisplay%, 1)
	IF INSTR(Control$, AChar$) THEN EXIT DO
	
	'The following can compress blanks into cursor codes.
	SaveAnsi% = 2
	IF (Linear% AND FilterSpace%) = TRUE THEN
	  IF INSTR(" " + CHR$(0) + CHR$(255), AChar$) AND ABack% = 0 THEN
	    SaveAnsi% = 0
	  ELSEIF ABack% = 0 AND AFore% = 0 THEN
	    SaveAnsi% = 0
	  ELSEIF ABack% = AFore% AND OldColor% <> -1 THEN
	    IF (OldColor% AND 112) = ABack% * 16 AND OldRow% = ARow% AND OldCol% = ACol% THEN
	      SaveAnsi% = 1
	      SaveAns$ = SaveAns$ + " "
	    END IF
	  END IF
	END IF
	IF SaveAnsi% = 2 THEN
	  IF ACol% = AWidth% AND Linear% = TRUE AND ABack% <> 0 THEN
	    TempRow% = OldRow%: TempCol% = OldCol%
	    SaveAns$ = SaveAns$ + ACode$(TempRow%, TempCol%, ARow%, ACol%, ColorValue% AND 143) + CHR$(13) + CHR$(10) + ACode$(OldRow% + 1, 1, ARow%, ACol%, ColorValue%) + AChar$
	  ELSE
	    SaveAns$ = SaveAns$ + ACode$(OldRow%, OldCol%, ARow%, ACol%, ColorValue%) + AChar$
	  END IF
	END IF
       
	IF ACol% = AWidth% THEN
	  ACol% = 1
	  IF ARow% <> ABot% AND ARow% <> AHeight% THEN ARow% = ARow% + 1
	ELSE
	  ACol% = ACol% + 1
	END IF
	IF SaveAnsi% THEN OldRow% = ARow%:  OldCol% = ACol%
	ADisplay% = ADisplay% + 1
      LOOP
      IF ADisplay% <= LEN(Astring$) THEN
	SELECT CASE ASC(AChar$)
	CASE 27: ANScode% = 1
	CASE 8
	  SaveAns$ = SaveAns$ + ACode$(OldRow%, OldCol%, ARow%, ACol%, ColorValue%) + CHR$(8)
	  IF ACol% > 1 THEN ACol% = ACol% - 1
	  OldRow% = ARow%: OldCol% = ACol%
	CASE 13
	  ACol% = 1
	CASE 10
	  IF NOT Linear% THEN
	    SaveAns$ = SaveAns$ + ACode$(OldRow%, OldCol%, ARow%, ACol%, ColorValue%) + AChar$
	    OldCol% = ACol%
	    OldRow% = ARow% + 1
	  END IF
	  ARow% = ARow% + 1
	  ExactLoc% = FALSE
	CASE 9
	  ACol% = ACol% - ((ACol% - 1) MOD 8) + 8
	  IF ACol% >= AWidth% THEN ACol% = AWidth%
	CASE 12
	  SaveAns$ = SaveAns$ + AColor$(ColorValue%) + CHR$(12)
	  AFore% = 3: ABack% = 0
	  ARow% = ATop%: ACol% = 1
	  OldRow% = ARow%: OldCol% = ACol%: OldColor% = 3
	  ExactLoc% = NEITHER: ColorKnown% = FALSE
	CASE 7
	  SaveAns$ = SaveAns$ + CHR$(7)
	END SELECT
      END IF
    ELSEIF ANScode% THEN
      AChar$ = MID$(Astring$, ADisplay%, 1)
      IF ANScode% = 2 THEN
	ANScode% = 0
	SELECT CASE INSTR(ANSchars$, AChar$)
	CASE IS > 17
	  IF LEN(ANSseq$) < 256 THEN ANSseq$ = ANSseq$ + AChar$ ELSE MID$(ANSseq$, 256) = AChar$
	  ANScode% = 2
	CASE 1       'm' SetColors
	  ColorKnown% = TRUE
	  IF ANSseq$ = "" THEN ANSseq$ = "0"
	  DO WHILE LEN(ANSseq$)
	    ATemp% = VAL(ANSseq$)
	    SELECT CASE ATemp%
	    CASE 30 TO 37: AFore% = (AFore% AND 24) OR ANScolorTran%(ATemp% - 30)
	    CASE 40 TO 47: ABack% = ANScolorTran%(ATemp% - 40)
	    CASE 0: AFore% = 7: ABack% = 0     ' reset colors
	    CASE 1: AFore% = AFore% OR 8       ' high intensity
	    CASE 5: AFore% = AFore% OR 16      ' blink
	    CASE 8: AFore% = ABack%            ' invisible
	    CASE 7                             ' reverse video
	      ATemp2% = AFore% AND 7
	      AFore% = (AFore% AND 24) OR ABack%
	      ABack% = ATemp2%
	    END SELECT
	    ATemp% = INSTR(ANSseq$, ";")
	    IF ATemp% THEN ANSseq$ = MID$(ANSseq$, ATemp% + 1) ELSE ANSseq$ = ""
	  LOOP
	CASE 2       'A' CursorUp
	  ATemp% = VAL(ANSseq$)
	  IF ATemp% < 1 THEN ATemp% = 1
	  IF ARow% >= ATop% AND (ARow% - ATemp%) <= ATop% THEN
	    ARow% = ATop%
	  ELSE
	    ARow% = ARow% - ATemp%
	    IF ARow% < 1 THEN ARow% = 1
	  END IF
	CASE 3       'B' CursorDown
	  ATemp% = VAL(ANSseq$)
	  IF ATemp% < 1 THEN ATemp% = 1
	  IF ARow% <= ABot% AND (ARow% + ATemp%) >= ABot% THEN
	    ARow% = ABot%
	  ELSE
	    ARow% = ARow% + ATemp%
	    IF ARow% > AHeight% THEN ARow% = AHeight%
	  END IF
	CASE 4       'C' CursorRight
	  ATemp% = VAL(ANSseq$)
	  IF ATemp% < 1 THEN ACol% = ACol% + 1 ELSE ACol% = ACol% + ATemp%
	  IF ACol% > AWidth% THEN ACol% = AWidth%
	CASE 5       'D' CursorLeft
	  ATemp% = VAL(ANSseq$)
	  IF ATemp% < 1 THEN ACol% = ACol% - 1 ELSE ACol% = ACol% - ATemp%
	  IF ACol% < 1 THEN ACol% = 1
	CASE 6, 7    'H', 'f' CursorLocate
	  ATemp% = INSTR(ANSseq$, ";")
	  IF ATemp% THEN
	    ACol% = VAL(MID$(ANSseq$, ATemp% + 1))
	    IF ACol% < 1 THEN
	      ACol% = 1
	    ELSEIF ACol% > AWidth% THEN
	      ACol% = AWidth%
	    END IF
	  ELSE
	    ACol% = 1
	  END IF
	  ARow% = VAL(ANSseq$)
	  IF ARow% < 1 THEN ARow% = 1
	  IF ExactLoc% = FALSE THEN ExactLoc% = TRUE
	CASE 8       's' SaveCursorPosn
	  ASavRow% = ARow%: ASavCol% = ACol%
	  PosStat% = ExactLoc%
	CASE 9       'u' ResetCursorPosn
	  IF ASavRow% < 1 THEN ASavRow% = 1
	  IF ASavCol% < 1 THEN ASavCol% = 1
	  ARow% = ASavRow%: ACol% = ASavCol%
	  ExactLoc% = PosStat%
	CASE 10, 11  'J', 'K' SmallErase, BigErase
	  SaveAns$ = SaveAns$ + ACode$(OldRow%, OldCol%, ARow%, ACol%, ColorValue%)
	  ATemp% = VAL(ANSseq$)
	  IF ATemp% = 0 THEN
	    SaveAns$ = SaveAns$ + escbr$ + AChar$
	  ELSE
	    SaveAns$ = SaveAns$ + escbr$ + LTRIM$(STR$(ATemp%)) + AChar$
	    IF AChar$ = "J" AND ATemp% = 2 THEN
	      ARow% = 1: ACol% = 1
	      OldRow% = 1: OldCol% = 1
	      ExactLoc% = NEITHER
	    END IF
	  END IF
	CASE 12 TO 15  'L' InsLine, 'M' DelLine, '@' InsSpace,  'P' DelChar
	  SaveAns$ = SaveAns$ + ACode$(OldRow%, OldCol%, ARow%, ACol%, ColorValue%)
	  ATemp% = VAL(ANSseq$)
	  IF ATemp% < 1 THEN
	    SaveAns$ = SaveAns$ + escbr$ + AChar$
	  ELSE
	    SaveAns$ = SaveAns$ + escbr$ + LTRIM$(STR$(ATemp%)) + AChar$
	  END IF
	CASE 17     'r' Set scrolling region
	  ATemp% = INSTR(ANSseq$, ";")
	  ATop% = VAL(ANSseq$)
	  IF ATop% = 0 THEN ATop% = 1
	  IF ATemp% THEN
	    ABot% = VAL(MID$(ANSseq$, ATemp% + 1))
	    SaveAns$ = SaveAns$ + escbr$ + LTRIM$(STR$(ATop%)) + ";" + LTRIM$(STR$(ABot%)) + "r"
	    IF ABot% = 0 THEN ABot% = AHeight%
	    IF ATop% > ABot% THEN ATop% = 1: ABot% = AHeight%
	  ELSE
	    SaveAns$ = SaveAns$ + escbr$ + LTRIM$(STR$(ATop%)) + "r"
	    ABot% = AHeight%
	  END IF
	  ARow% = 1: ACol% = 1
	  ExactLoc% = TRUE
	CASE ELSE
	  IF Preserve% THEN SaveAns$ = SaveAns$ + ACode$(OldRow%, OldCol%, ARow%, ACol%, ColorValue%) + escbr$ + ANSseq$ + AChar$
	END SELECT
      ELSE
	IF AChar$ = "[" THEN
	  ANScode% = 2
	  ANSseq$ = ""
	ELSE
	  SELECT CASE AChar$
	  CASE "D", "E"    'Linefeed / Next Line
	    SaveAns$ = SaveAns$ + ACode$(OldRow%, OldCol%, ARow%, ACol%, ColorValue%) + esc$ + AChar$
	    IF AChar$ = "E" THEN ACol% = 1
	    Astring$ = CHR$(10) + MID$(Astring$, ADisplay% + 1): ADisplay% = 0
	  CASE "M"         'Reverse Linefeed
	    SaveAns$ = SaveAns$ + ACode$(OldRow%, OldCol%, ARow%, ACol%, ColorValue%) + esc$ + AChar$
	    IF ARow% > 1 AND ARow% <> ATop% THEN ARow% = ARow% - 1
	    OldRow% = ARow%: OldCol% = ACol%
	  CASE ELSE
	    IF Preserve% THEN SaveAns$ = SaveAns$ + ACode$(OldRow%, OldCol%, ARow%, ACol%, ColorValue%) + esc$ + AChar$
	  END SELECT
	  ANScode% = 0
	END IF
      END IF
    END IF
    ADisplay% = ADisplay% + 1
  LOOP
END SUB

SUB AInit

  'The following are IBM-PC to ANSI color translation tables.
  ANScolorTran%(0) = 0
  ANScolorTran%(1) = 4
  ANScolorTran%(2) = 2
  ANScolorTran%(3) = 6
  ANScolorTran%(4) = 1
  ANScolorTran%(5) = 5
  ANScolorTran%(6) = 3
  ANScolorTran%(7) = 7
  FOR I% = 0 TO 7
    ANScolorForeStr$(I%) = ";3" + LTRIM$(STR$(ANScolorTran%(I%)))
    ANScolorBackStr$(I%) = ";4" + LTRIM$(STR$(ANScolorTran%(I%)))
  NEXT

  'The below is the ANSI bold and blink attribute lookup table for the
  'efficient color-changing code function, AColor$.
  '  First #: Old bold flag      Third #: New bold flag
  ' Second #: Old blink flag    Fourth #: New blink flag
  ANSIattr$(0, 0, 0, 0) = ""
  ANSIattr$(0, 0, 0, 1) = ";5"
  ANSIattr$(0, 0, 1, 0) = ";1"
  ANSIattr$(0, 0, 1, 1) = ";1;5"
  ANSIattr$(0, 1, 0, 0) = ";0"
  ANSIattr$(0, 1, 0, 1) = ""
  ANSIattr$(0, 1, 1, 0) = ";0;1"
  ANSIattr$(0, 1, 1, 1) = ";1"
  ANSIattr$(1, 0, 0, 0) = ";0"
  ANSIattr$(1, 0, 0, 1) = ";0;5"
  ANSIattr$(1, 0, 1, 0) = ""
  ANSIattr$(1, 0, 1, 1) = ";5"
  ANSIattr$(1, 1, 0, 0) = ";0"
  ANSIattr$(1, 1, 0, 1) = ";0;5"
  ANSIattr$(1, 1, 1, 0) = ";0;1"
  ANSIattr$(1, 1, 1, 1) = ""

  Control$ = CHR$(7) + CHR$(8) + CHR$(9) + CHR$(10) + CHR$(12) + CHR$(13) + CHR$(27)
  AHeight% = 32767
  AWidth% = 80
  AFore% = 7
  ABack% = 0
  ARow% = 1
  ACol% = 1
  ATop% = 1
  ABot% = AHeight%
 
END SUB

FUNCTION ALocate$ (FromRow%, FromCol%, NewRow%, NewCol%)
  IF FromRow% = NewRow% AND FromCol% = NewCol% THEN EXIT FUNCTION

  'If an Esc[#;#r scroll zone is set in VT102 mode.
  IF FromRow% < ATop% OR NewRow% < ATop% OR FromRow% > ABot% OR NewRow% > ABot% THEN
    ATemp$ = escbr$ + LTRIM$(STR$(NewRow%))
    IF NewCol% = 1 THEN
      ALocate$ = ATemp$ + "H"
    ELSE
      ALocate$ = ATemp$ + ";" + LTRIM$(STR$(NewCol%)) + "H"
    END IF
    OldRow% = NewRow%: OldCol% = NewCol%
    EXIT FUNCTION
  END IF

  'The following creates 4 different codes to find out the most efficent one.
  Code1$ = "": Code2$ = "": Code3$ = "": Code4$ = ""
  HOffs% = NewCol% - FromCol%: HDiff% = ABS(HOffs%)
  VOffs% = NewRow% - FromRow%: VDiff% = ABS(VOffs%)

  IF Linear% THEN
  
    '1:Absolute locate
    IF ExactLoc% = TRUE THEN
      IF NewCol% = 1 THEN
	Code1$ = escbr$ + LTRIM$(STR$(NewRow%)) + "H"
      ELSE
	Code1$ = escbr$ + LTRIM$(STR$(NewRow%)) + ";" + LTRIM$(STR$(NewCol%)) + "H"
      END IF
      ExactLoc% = NEITHER
      ALocate$ = Code1$
      OldRow% = NewRow%: OldCol% = NewCol%
      EXIT FUNCTION
    END IF

    '2:Relative locate
    IF VOffs% > 0 THEN  'Vertical
      IF VDiff% = 1 THEN Code2$ = ANSdown$ ELSE Code2$ = escbr$ + LTRIM$(STR$(VDiff%)) + "B"
    ELSEIF VOffs% < 0 THEN
      IF VDiff% = 1 THEN Code2$ = ANSup$ ELSE Code2$ = escbr$ + LTRIM$(STR$(VDiff%)) + "A"
    END IF
    IF HOffs% > 0 THEN  'Horizontal
      IF HDiff% = 1 THEN Code2$ = Code2$ + ANSright$ ELSE Code2$ = Code2$ + escbr$ + LTRIM$(STR$(HDiff%)) + "C"
    ELSEIF HOffs% < 0 THEN
      IF HDiff% = 1 THEN Code2$ = Code2$ + ANSleft$ ELSE Code2$ = Code2$ + escbr$ + LTRIM$(STR$(HDiff%)) + "D"
    END IF
   
    '3:Spaces
    IF (OldColor% AND 112) = 0 OR OldColor% = -1 THEN
      IF NewRow% = FromRow% AND HOffs% > 0 THEN
	Code3$ = SPACE$(HDiff%)
      ELSEIF NewRow% > FromRow% THEN
	IF FromCol% = 1 THEN Code3$ = "" ELSE Code3$ = CHR$(13)
	Code3$ = Code3$ + STRING$(VDiff%, CHR$(10)) + SPACE$(NewCol% - 1)
      END IF
    END IF

    '4:Carrige return and linefeeds (and relative cursor movement)
    IF VOffs% >= 0 THEN
      TempColor% = -1
      IF VOffs% > 0 THEN
	Temp% = OldColor%
	Code4$ = AColor$(OldColor% AND 143)
	TempColor% = OldColor%
	OldColor% = Temp%
      END IF
      IF FromCol% > 1 THEN Code4$ = Code4$ + CHR$(13)
      Code4$ = Code4$ + STRING$(VDiff%, CHR$(10))
      IF NewCol% = 2 THEN
	Code4$ = Code4$ + ANSright$
      ELSEIF NewCol% > 2 THEN
	Code4$ = Code4$ + escbr$ + LTRIM$(STR$(NewCol% - 1)) + "C"
      END IF
    ELSEIF NewCol% = 1 THEN
      IF FromCol% = 1 THEN Code4$ = "" ELSE Code4$ = CHR$(13)
      IF VDiff% = 1 THEN
	Code4$ = Code4$ + ANSup$
      ELSE
	Code4$ = Code4$ + escbr$ + LTRIM$(STR$(VDiff%)) + "A"
      END IF
    END IF

    IF LEN(Code2$) > 10 AND RTRIM$(Code2$) = "" THEN STOP
    IF VOffs% > 0 THEN Code2$ = ""
  
    MostEff$ = Code2$
    IF LEN(Code3$) THEN IF LEN(MostEff$) = 0 OR LEN(Code3$) <= LEN(MostEff$) THEN MostEff$ = Code3$
    IF LEN(Code4$) THEN IF LEN(MostEff$) = 0 OR LEN(Code4$) <= LEN(MostEff$) THEN MostEff$ = Code4$: IF TempColor% >= 0 THEN OldColor% = TempColor%

  ELSE 'NOT Linear%
     
    '1:Absolute locate
    IF ExactLoc% <> FALSE THEN
      IF NewCol% = 1 THEN
	Code1$ = escbr$ + LTRIM$(STR$(NewRow%)) + "H"
      ELSE
	Code1$ = escbr$ + LTRIM$(STR$(NewRow%)) + ";" + LTRIM$(STR$(NewCol%)) + "H"
      END IF
      IF ExactLoc% = TRUE THEN
	ExactLoc% = NEITHER
	ALocate$ = Code1$
	OldRow% = NewRow%: OldCol% = NewCol%
	EXIT FUNCTION
      END IF
    END IF

    '2:Relative locate
    IF VOffs% > 0 THEN  'Vertical
      IF VDiff% = 1 THEN Code2$ = ANSdown$ ELSE Code2$ = escbr$ + LTRIM$(STR$(VDiff%)) + "B"
    ELSEIF VOffs% < 0 THEN
      IF VDiff% = 1 THEN Code2$ = ANSup$ ELSE Code2$ = escbr$ + LTRIM$(STR$(VDiff%)) + "A"
    END IF
    IF HOffs% > 0 THEN  'Horizontal
      IF HDiff% = 1 THEN Code2$ = Code2$ + ANSright$ ELSE Code2$ = Code2$ + escbr$ + LTRIM$(STR$(HDiff%)) + "C"
    ELSEIF HOffs% < 0 THEN
      IF HDiff% = 1 THEN Code2$ = Code2$ + ANSleft$ ELSE Code2$ = Code2$ + escbr$ + LTRIM$(STR$(HDiff%)) + "D"
    END IF
 
    '4:Carrige return and linefeeds (and relative cursor movement)
    IF VOffs% >= 0 THEN
      IF FromCol% = 1 THEN Code4$ = "" ELSE Code4$ = CHR$(13)
      Code4$ = Code4$ + STRING$(VDiff%, CHR$(10))
      IF NewCol% = 2 THEN
	Code4$ = Code4$ + ANSright$
      ELSEIF NewCol% > 2 THEN
	Code4$ = Code4$ + escbr$ + LTRIM$(STR$(NewCol% - 1)) + "C"
      END IF
    ELSEIF NewCol% = 1 THEN
      IF FromCol% = 1 THEN Code4$ = "" ELSE Code4$ = CHR$(13)
      IF VDiff% = 1 THEN
	Code4$ = Code4$ + ANSup$
      ELSE
	Code4$ = Code4$ + escbr$ + LTRIM$(STR$(VDiff%)) + "A"
      END IF
    END IF
    MostEff$ = Code1$
    IF LEN(Code2$) THEN IF LEN(MostEff$) = 0 OR LEN(Code2$) <= LEN(MostEff$) THEN MostEff$ = Code2$
    IF LEN(Code4$) THEN IF LEN(MostEff$) = 0 OR LEN(Code4$) <= LEN(MostEff$) THEN MostEff$ = Code4$
  END IF

  ALocate$ = MostEff$
  OldRow% = NewRow%: OldCol% = NewCol%
END FUNCTION

FUNCTION ColorValue%
  ColorValue% = (AFore% AND 15) + (ABack% * 16) + (AFore% \ 16) * 128
END FUNCTION

