'EXT library functions
DECLARE FUNCTION WeekDay% (Day%)
DECLARE FUNCTION Exist2% (FileName$)
DECLARE FUNCTION DriveSpace& (Drive$)
DECLARE SUB Checksum (St$, ChkSum%)
DECLARE SUB CRC (St$, CRCmsb%, CRClsb%)
DECLARE SUB FindFirstF (FileName$, BYVAL Attr%, ErrCode%)
DECLARE SUB FindNextF (ErrCode%)
DECLARE SUB GetAttrF (Attr%)
DECLARE SUB GetDateF (MonthNr%, Day%, Year%)
DECLARE SUB GetNameF (FileName$, FileNameLen%)
DECLARE SUB GetSizeF (LowWord%, HighWord%)
DECLARE SUB GetTimeF (Hour%, Minute%, Second%)
DECLARE SUB Editor (text$, LeftCol%, RightCol%, keycode%)
DECLARE SUB Box (BType%, BChar%, BTop%, BLeft%, BBot%, BRight%, BFore%, BBack%)

'ATERM library functions
DECLARE SUB SetScrSize (BYVAL SWidth%, BYVAL SHeight%)
  'Tells GetBlock and PutBlock what size the screen is. Defaults at 80x25.
DECLARE SUB GetBlock (BYVAL BSeg%, BYVAL BOffs%, BYVAL BTopRow%, BYVAL BLeftCol%, BYVAL BBlockHt%, BYVAL BBlockWid%)
  'Captures a block of text off the screen, with safety checking.
DECLARE SUB PutBlock (BYVAL BSeg%, BYVAL BOffs%, BYVAL BTopRow%, BYVAL BLeftCol%, BYVAL BBlockHt%, BYVAL BBlockWid%)
  'Puts a block of text back to the screen, with safety checking.
DECLARE SUB GetBlock2 (BYVAL BSeg%, BYVAL BOffs%, BYVAL BTop%, BYVAL BLeft%, BYVAL BBot%, BYVAL BRight%)
  'Same as GetBlock but uses Right col / Bottom row instead of width / height.
DECLARE SUB PutBlock2 (BYVAL BSeg%, BYVAL BOffs%, BYVAL BTop%, BYVAL BLeft%, BYVAL BBot%, BYVAL BRight%)
  'Same as PutBlock but uses Right col / Bottom row instead of width / height.
DECLARE SUB ScrollBlock (BYVAL Dir%, BYVAL BLines%, BYVAL BFore%, BYVAL BBack%, BYVAL BTop%, BYVAL BLeft%, BYVAL BBot%, BYVAL BRight%)
  'Scrolls a window on the screen, or clears window if BLines% = 0.
DECLARE SUB FillBlock (BYVAL BColor%, BYVAL BChar%, BYVAL BTop%, BYVAL BLeft%, BYVAL BBot%, BYVAL BRight%)
  'Fill a box on the screen to an attribute and character.
DECLARE FUNCTION ContCode% (BYVAL OldPos%, Astring AS STRING)
  'Scans for the next position of a control code (Includes Esc, Enter, BS)
  'in a string. Used for ANSI or AVATAR subroutine.

'TICK library functions
DECLARE FUNCTION Time&                        '1/100 secs since midnight
DECLARE FUNCTION TimePassed& (BYVAL OldTime&) 'Diff. btwn now and old Time&
DECLARE FUNCTION Tick&                        '1/18.2 secs since midnight
DECLARE FUNCTION TickPassed& (BYVAL OldTick&) 'Diff. btwn now and old Tick&

'FOSSIL library functions
'The Port% parameter represents the FOSSIL COM port number.
DECLARE SUB CLocate (BYVAL CRow%, BYVAL CCol%)
  'Locates the DOS cursor.
DECLARE SUB CReadLocate (CRow%, CCol%)
  'Reads the DOS cursor's location.
DECLARE SUB FBaudRate (BYVAL Port%, FRate&, FParm$)
  'Sets the baud rate to 300 600 1200 2400 4800 9600 19200 or 38400
  'Sets comm parameters 5/6/7/8, N/E/O, 1/2 in format '8N1'
DECLARE SUB FInitialize (BYVAL Port%, Erred%)
  'Initializes a COM port. Erred% = -1 if unsucessful, otherwise equals
  'FOSSIL's revision number, usually 5.
DECLARE SUB FClose (BYVAL Port%)
  'Deinitializes a COM port.
DECLARE SUB FDtr (BYVAL Port%, BYVAL State%)
  'Toggle the state of DTR. DTR is turned on if State% is nonzero.
DECLARE SUB FOutFlush (BYVAL Port%)
  'Waits for the outgoing buffer to finish transmitting.
DECLARE SUB FOutClear (BYVAL Port%)
  'Immediately erases the outgoing buffer.
DECLARE SUB FInClear (BYVAL Port%)
  'Immediately erases the incoming buffer.
DECLARE SUB FSend (BYVAL Port%, SendMessage AS STRING)
  'Puts string in the outgoing buffer (without buffer overrun checking)
DECLARE SUB FSendBlock (BYVAL Port%, SendMessage AS STRING, NumChars%)
  'Puts as much of the string as possible into the outgoing buffer,
  'NumChars% is the no. of chars actually put into the buffer.
DECLARE SUB FSendChar (BYVAL Port%, Char AS STRING)
  'Puts one character in the outgoing buffer (Char can a )
DECLARE FUNCTION FRead$ (BYVAL Port%)
  'Returns a string (Maximum 256 characters at a time) from the incoming buffer
  'Blank ("") if no characters
DECLARE FUNCTION FInkey$ (BYVAL Port%)
  'Returns one character from the incoming buffer. Blank ("") if no characters.
DECLARE FUNCTION FOutStat% (BYVAL Port%)
  'Returns state of outgoing buffer, 0=empty, 1=not empty, 2=buffer full
DECLARE FUNCTION FInStat% (BYVAL Port%)
  'Returns state of incoming buffer, 0=empty, 1=not empty, 2=buffer overrun
DECLARE FUNCTION FCarrier% (BYVAL Port%)
  'Returns the state of carrier detect, nonzero if there is a carrier.
DECLARE SUB FBuffInfo (BYVAL Port%, InBuffSize%, InBuffChars%, OutBuffSize%, OutBuffChars%)
  'Returns information about the buffer.  Incoming buffer size, chars in
  'incoming buffer, Outgoing buffer size, and chars in outgoing buffer.

'DV library functions
DECLARE FUNCTION DVRunning%
DECLARE SUB DVSlice            'Returns CPU timeslice
DECLARE SUB DVwrite (DVstr$)
  'Refer to Ralf Brown's interrupt list, INT 15h AH=12h BX=0501h, write
  'string with special escape codes to DesqView window.

'CTRLC library functions
DECLARE SUB CaptureBrk (CtrlFlag%)
  'Disable/enable Ctrl-Break, useful for DOS shells, etc.

'QB library functions
TYPE RegType
     ax    AS INTEGER
     bx    AS INTEGER
     cx    AS INTEGER
     dx    AS INTEGER
     bp    AS INTEGER
     si    AS INTEGER
     di    AS INTEGER
     flags AS INTEGER
END TYPE
TYPE RegTypeX
     ax    AS INTEGER
     bx    AS INTEGER
     cx    AS INTEGER
     dx    AS INTEGER
     bp    AS INTEGER
     si    AS INTEGER
     di    AS INTEGER
     flags AS INTEGER
     ds    AS INTEGER
     es    AS INTEGER
END TYPE
DECLARE SUB INTERRUPT (Intnum%, Inreg AS RegType, Outreg AS RegType)
DECLARE SUB INTERRUPTX (Intnum%, Inreg AS RegTypeX, Outreg AS RegTypeX)
DIM SHARED Regs AS RegType, RegsX AS RegTypeX

