DEFINT A-Z
DECLARE SUB Typing ()
'This program allows the user to test his or her typing speed by typing
'several Words and pressing Enter. This program is just a simple experiment
'and since other people may to have a quick test of their typing, I have
'decided to release this program.
'
'Programmer: Mark D. Rejhon
'Version 0.1    First made  Apr 1, 1991     (256 characters)
'Version 0.11      Updated  Apr 2, 1991     (Improved calculations scheme)
'Version 0.2       Updated Apr 13, 1991     (Full screen worth of characters)
'Version 0.3       Updated Apr 23, 1991     (32767 characters)
'Version 0.4       Updated Apr 23, 1991     (More detailed output)
'Version 1.0       Updated Aug 17, 1992     Release of this program
'Version 1.01      Updated Jun 10, 1993     (Backspace key report)

CONST WrapCol% = 77
CONST WrapLen% = 15
DIM SHARED Lev, Test$, StartTime!, EndTime!, Backs%

' The following shows the typist the purpose of this program.
WIDTH 80, 25
CLS
COLOR 2, 4
PRINT "          Typing speed benchmark!  Programmed 1993 by Mark D. Rejhon            "
COLOR 14
PRINT "    Type anything you wish! (Perhaps recite a paragraph from the newspaper?)    "
COLOR 7, 0
PRINT
PRINT "The first keypress starts the timer. Hit ESC when finished typing.";
COLOR 14

' The following initializes the necessary variables for this program.
Lev = 0
Test$ = STRING$(32767, " ")

' The following is the sub which gets input from the user, up to one full
' screen's worth of information.
Typing

' The following loops counts the words in the text the typist entered.
EndCount = Lev
NumChars = Lev
SecLapsed! = EndTime! - StartTime!
IF SecLapsed! < 0 THEN SecLapsed! = SecLapsed! + 86400
  'Just in case typing started before midnight and ended after midnight.
Words = 0
Count = 0
DO
  DO
    Count = Count + 1
    Char$ = MID$(Test$, Count, 1)
  LOOP UNTIL INSTR(CHR$(13) + " -", Char$) <> 0 OR Count >= EndCount
  Words = Words + 1
  IF Count >= EndCount THEN EXIT DO
  DO
    Count = Count + 1
    Char$ = MID$(Test$, Count, 1)
  LOOP UNTIL INSTR(CHR$(13) + " -", Char$) = 0 OR Count >= EndCount
LOOP UNTIL Count >= EndCount
IF RTRIM$(Test$) = "" THEN
  Words = 0
  AvgLen! = 0
ELSE
  AvgLen! = INT((NumChars - Words + 1) / Words * 10) / 10
END IF

' The following calculates the typist's speed, and then outputs to the screen
' to let the typist know.
COLOR 15
IF SecLapsed! THEN
  WPM! = INT(Words / (SecLapsed! / 60) * 10) / 10
  CPM! = INT(NumChars / (SecLapsed! / 60) * 10) / 10
  Erred! = INT((Backs% / NumChars) * 1000) / 10
END IF

PRINT
PRINT
PRINT "     Time between first and last key: "; RTRIM$(STR$(INT(SecLapsed! * 10) / 10)); "s"
PRINT "                     Number of Words: "; Words
PRINT "                 Average word length: "; AvgLen!; "chars"
PRINT
PRINT "                Number of characters: "; NumChars
PRINT "                  Data transfer rate: "; RTRIM$(STR$(INT(CPM! / 6) / 10)); "cps"
PRINT "               Characters per minute: "; CPM!; "CPM"
PRINT "                         Backspacing: "; Backs%; "times"
PRINT "                          Error rate: "; RTRIM$(STR$(Erred!)); "%"
PRINT
PRINT "                         Counted WPM: "; WPM!
PRINT "                        Official WPM: "; INT(CPM! / 5 * 10) / 10; "WPM"

SUB Typing STATIC
  DO
    DO
      Keyy$ = INKEY$
    LOOP UNTIL Keyy$ <> ""
    IF First% = 0 THEN
      StartTime! = TIMER
      EndTime! = TIMER
      First% = 1
      LOCATE , 1, 1
      PRINT STRING$(79, " ")
    END IF
    SELECT CASE Keyy$
    CASE IS >= " "      'Ordinary keypress
      IF POS(0) > WrapCol THEN               'Word wrapping code below
        IF Keyy$ <> " " THEN
          Leng = Lev
          DO WHILE MID$(Test$, Leng, 1) <> " " AND Lev - Leng <= WrapLen
            Leng = Leng - 1
          LOOP
          LLeng = Lev - Leng
          IF LLeng <= WrapLen THEN
            LOCATE , POS(0) - LLeng
            PRINT SPACE$(LLeng)
            Lev = Leng
            MID$(Test$, Lev) = CHR$(13)
            Keyy$ = MID$(Test$, Leng + 1, LLeng) + Keyy$
          ELSE
            Keyy$ = CHR$(13) + Keyy$
          END IF
        ELSE
          Keyy$ = CHR$(13)
        END IF
      END IF
      PRINT Keyy$;
      MID$(Test$, Lev + 1) = Keyy$
      Lev = Lev + LEN(Keyy$)
    CASE CHR$(8)        'Backspace
      Backs% = Backs% + 1
      IF Lev > 0 THEN
        IF POS(0) = 1 AND CSRLIN > 1 THEN   'The code below is to move the
          Leng = Lev - 1                    'cursor to the previous line.
          DO WHILE Leng >= 1
            IF MID$(Test$, Leng, 1) = CHR$(13) OR Lev - Leng > 79 THEN EXIT DO
            Leng = Leng - 1
          LOOP
          IF Lev - Leng <= 79 THEN
            LOCATE CSRLIN - 1, Lev - Leng
            Lev = Lev - 1
          END IF
        ELSE
          PRINT CHR$(29); " "; CHR$(29);
          Lev = Lev - 1
        END IF
      END IF
    CASE CHR$(13)       'Enter
      PRINT
      Lev = Lev + 1
      MID$(Test$, Lev) = Keyy$
    CASE CHR$(27)       'Esc
      EXIT SUB
    END SELECT
    EndTime! = TIMER
  LOOP UNTIL Lev = 32767
END SUB

